/*
    TCFbEToolkit.h    June 6, 2004.

    Copyright (C) 2003-2005 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#ifndef TCFbEToolkitH
#define TCFbEToolkitH
//---------------------------------------------------------------------------
#include <ComCtrls.hpp>
#include <Forms.hpp>
#include <math.h>
#include <system.hpp>
//---------------------------------------------------------------------------
enum TSortDirection { sdAscending, sdDescending };
//---------------------------------------------------------------------------
struct TVersion {
    unsigned int    Major;    // W[o[W
    unsigned int    Minor;    // }Ci[o[W
    unsigned int    Revision;    // rW
    unsigned int    Build;    // rh
    AnsiString    VersionString;
};

//---------------------------------------------------------------------------
// vOŜŎgpO[oȊ֐萔Cϐ܂ރNX
class TCFbEToolkit: public TObject
{
public:
    __fastcall ~TCFbEToolkit();                                                        // fXgN^iKAvP[ṼfXgN^ŊJ邱

    static TCFbEToolkit* __fastcall GetToolkit();                                    // t@Ng\bhCVOgƂĎTCFbEToolkit𓾂Ƃ͂̃\bh@
    static void __fastcall DeleteToolkit();                                            // c[Lbg

    virtual void __fastcall CopyList(TList* SourceList, TList* DestinationList);    // TList^̃Rs[

    virtual bool __fastcall Equals(TFont* Font0, TFont* Font1);                        // Font0  Font1 ̃tHg true 𓙂Ȃ false Ԃ܂D
    virtual bool __fastcall Equals(double Value0, double Value1, double ErrorRange=1E-6);    // Value0  Value1 rD덷 ErrorRange ȉȂ瓙Ƃ

    virtual void __fastcall DebugOutput(AnsiString OutputString);    // AvP[V݂fBNgɃfobOt@Ci"debug.txt"jo͂

    virtual void __fastcall SetApplicationPriority(TThreadPriority Priority);        // AvP[ṼvCIeBύX

    virtual void __fastcall SortDoubleDynArray(TDoubleDynArray& DynArray, TSortDirection Direction=sdDescending);    // DynArray \[g
    virtual double __fastcall GetAverageOfDynArray(TDoubleDynArray& DynArray);    // DynArray ̗vf̕ϒlԂ
    virtual double __fastcall GetMedianOfDynArray(TDoubleDynArray& DynArray);    // DynArray ̗vf̒ԒlԂiDynArray ̓\[gĂKv

    virtual void __fastcall CsvToStrings(AnsiString str,TStrings *List);    // CSV`̕TStringsɕ
    virtual void __fastcall Exchange(TDoubleDynArray& Array, int Index1, int Index2);    // Array  Index1  Index2 ̗vfւ
    virtual AnsiString __fastcall GetExeVersion(AnsiString FileName);
    virtual AnsiString __fastcall GetCopyrightStr(AnsiString ApplicationName);

protected:
    virtual __fastcall TCFbEToolkit();    // RXgN^
    virtual bool __fastcall IsQuote(char c) { return (c=='\"' || c=='\''); }    // CsvToStrings \bhŎg
    virtual bool __fastcall IsDelimiter(char c) { return (c==','); }    // CsvToStrings \bhŎg}N

    static TCFbEToolkit* Instance;    // CX^X

    TStringList* DebugStringList;    // debug.txt o͂邽߂̕񃊃Xg

private:
};
TCFbEToolkit* TCFbEToolkit::Instance = NULL;    // TCFbEToolkit̎

//---------------------------------------------------------------------------
#endif
