//---------------------------------------------------------------------------
#include <vcl.h>
#include <stdio.h>
#include <stdlib.h>
#include "TCFbEPrimitiveTable.h"
#include "TCFbECell.h" 
#pragma hdrstop
//---------------------------------------------------------------------------
TCFbEPrimitiveTable* loadtable(TFileName FileName, int NeighborsSize)
{
    TStringList* InputFileStringList = new TStringList();
    InputFileStringList->LoadFromFile(FileName);

    InputFileStringList->Delete(0);
    InputFileStringList->Delete(0);
    InputFileStringList->Delete(InputFileStringList->Count - 1);
    InputFileStringList->Delete(InputFileStringList->Count - 1);

    TCFbEPrimitiveTable* DataTable = new TCFbEPrimitiveTable(InputFileStringList);
    delete InputFileStringList;

    // NeighborsSize ȏ Neighbors m[hɊւẮCNeighborsSize 葽 Neighbors ̗ގx -1.0 ɂĐqȂ悤ɂ
    if ((NeighborsSize > 0) && (DataTable->GetNumberOfColumns() > NeighborsSize)) {
        for (int i = 0; i < DataTable->GetNumberOfRows(); i++) {
            TList* SortedCellList = new TList();
            DataTable->GetSortedCellListOfRow(i, SortedCellList);
            for (int j = NeighborsSize + 1; j < SortedCellList->Count; j++) {
                ((TCFbECell*)SortedCellList->Items[j])->SetValue(-1.0);
            }

            // ̗ގxs̗ގxɍ킹
            for (int j = 0; j < DataTable->GetNumberOfRows(); j++) {
                DataTable->SetValueByIndex(j, i, DataTable->GetValueByIndex(i, j));
            }
            delete SortedCellList;
        }
    }

    return DataTable;
}

//---------------------------------------------------------------------------
void checkconnectednodes(TCFbEPrimitiveTable* DataTable, TStringList* ConnectedNodeList, double Threshold)
{
    for (int i = 0; i < DataTable->GetNumberOfRows(); i++) {
        for (int j = 0; j < DataTable->GetNumberOfRows(); j++) {
            if ((i != j) && (DataTable->GetValueByIndex(i, j) > Threshold)) {
                ConnectedNodeList->Add(DataTable->GetRowLabelList()->Strings[i]);
                break;
            }
        }
    }
}

//---------------------------------------------------------------------------
void deletenodes(TCFbEPrimitiveTable* DataTable, TStringList* DeletedNodeList)
{
    for (int i = 0; i < DeletedNodeList->Count; i++) {
        DataTable->DeleteRow(DeletedNodeList->Strings[i].c_str());
        DataTable->DeleteColumn(DeletedNodeList->Strings[i].c_str());
    }
}

//---------------------------------------------------------------------------
bool isdeletednode(AnsiString CurrentNode, TCFbEPrimitiveTable* SourceDataTable, TStringList* ConnectedNodeList, TStringList* OpponentConnectedNodeList, bool TargetIsUserNodes, bool ShowIsolatedNodes)
{
    if (ConnectedNodeList->IndexOf(CurrentNode) != -1) {
        return false;
    }
    if (!ShowIsolatedNodes) {
        return true;
    }
    for (int j = 0; j < OpponentConnectedNodeList->Count; j++) {
        if (TargetIsUserNodes) {
            if (SourceDataTable->GetEnabled(CurrentNode.c_str(), OpponentConnectedNodeList->Strings[j].c_str())) {
                return false;
            }
        } else {
            if (SourceDataTable->GetEnabled(OpponentConnectedNodeList->Strings[j].c_str(), CurrentNode.c_str())) {
                return false;
            }
        }
    }
    return true;
}

//---------------------------------------------------------------------------
void trimnodes(TCFbEPrimitiveTable* UsersTable, TCFbEPrimitiveTable* ItemsTable, TCFbEPrimitiveTable* SourceDataTable, int NeighborsSize, double Threshold, bool ShowIsolatedNodes)
{
    // Threshold ȏ̗ގxĂs𒲂ׂ
    TStringList* ConnectedUsersList = new TStringList();
    TStringList* ConnectedItemsList = new TStringList();
    checkconnectednodes(UsersTable, ConnectedUsersList, Threshold);
    checkconnectednodes(ItemsTable, ConnectedItemsList, Threshold);

    // ConnectedNodeList Ɋ܂܂ĂȂCCOpponentConnectedNodeList Ɋ܂܂Ăm[hڑĂȂm[h𒲂ׁC폜Ώۂ̃m[hƂă`FbN
    TStringList* DeletedUsersList = new TStringList();
    for (int i = 0; i < UsersTable->GetNumberOfRows(); i++) {
        if (isdeletednode(UsersTable->GetRowLabelList()->Strings[i], SourceDataTable, ConnectedUsersList, ConnectedItemsList, true, ShowIsolatedNodes)) {
            DeletedUsersList->Add(UsersTable->GetRowLabelList()->Strings[i]);
        }
    }

    TStringList* DeletedItemsList = new TStringList();
    for (int i = 0; i < ItemsTable->GetNumberOfRows(); i++) {
        if (isdeletednode(ItemsTable->GetRowLabelList()->Strings[i], SourceDataTable, ConnectedItemsList, ConnectedUsersList, false, ShowIsolatedNodes)) {
            DeletedItemsList->Add(ItemsTable->GetRowLabelList()->Strings[i]);
        }
    }

    deletenodes(UsersTable, DeletedUsersList);
    deletenodes(ItemsTable, DeletedItemsList);

    delete DeletedItemsList;
    delete DeletedUsersList;
    delete ConnectedItemsList;
    delete ConnectedUsersList;
}

//---------------------------------------------------------------------------
void addnodes(TStringList* OutputStringList, TCFbEPrimitiveTable* DataTable, AnsiString NodeNamePrefix, AnsiString NodeCharColor, AnsiString NodeBackColor, AnsiString NodeImageUrl, AnsiString NodeLinkPrefix)
{
    for (int i = 0; i < DataTable->GetNumberOfRows(); i++) {
        // <node name="1"><label>AAAAAA</label><style><line colour="black"/><fill colour="#ffcccc"/></style><dataref><ref xlink:href="http://se.naist.jp"/></dataref></node>
        AnsiString NodeName = DataTable->GetRowLabelList()->Strings[i];
        AnsiString NodeString = "    ";
        NodeString += "<node name=\"" + NodeNamePrefix + IntToStr(i) + "\">";
        NodeString += "<label>" + NodeName + "</label>";
        NodeString += "<style>";
        NodeString += "<line colour=\"" + NodeCharColor + "\" />";

        if (!NodeBackColor.IsEmpty()) {
            if (!NodeImageUrl.IsEmpty()) {
                NodeString += "<fill colour=\"" + NodeBackColor + "\" xlink:href=\"" + NodeImageUrl + "\" />";
            } else {
                NodeString += "<fill colour=\"" + NodeBackColor + "\" />";
            }
        } else if (!NodeImageUrl.IsEmpty()) {
            NodeString += "<fill xlink:href=\"" + NodeImageUrl + "\" />";
        }

        NodeString += "</style>";
        if (!NodeLinkPrefix.IsEmpty()) {
            NodeString += "<dataref><ref xlink:show=\"new\" xlink:href=\"" + NodeLinkPrefix + NodeName + "/\" /></dataref>";
        }
        NodeString += "</node>";
        OutputStringList->Add(NodeString);

        fprintf(stderr, "\b\b\b\b\b\b%5.2f\%", i / (double)DataTable->GetNumberOfRows() * 100.0);
    }
    fprintf(stderr, "\b\b\b\b\b\b%5.2f\%\n", 100.0);
    OutputStringList->Add("");
    fprintf(stderr, "\n");
}

//---------------------------------------------------------------------------
bool isisolatednode(TCFbEPrimitiveTable* DataTable, double Threshold, int TargetIndex)
{
    for (int j = 0; j < DataTable->GetNumberOfColumns(); j++) {
        if ((TargetIndex != j) && (DataTable->GetValueByIndex(TargetIndex, j) > Threshold)) {
            return false;
        }
    }
    return true;
}

//---------------------------------------------------------------------------
void addedges(TStringList* OutputStringList, TCFbEPrimitiveTable* DataTable, double Threshold, AnsiString NodeNamePrefix, AnsiString EdgeColor, AnsiString EdgeType, bool ShowIsolatedNodes)
{
    for (int i = 0; i < DataTable->GetNumberOfRows(); i++) {
        for (int j = i + 1; j < DataTable->GetNumberOfRows(); j++) {
            double Similarity = DataTable->GetValueByIndex(i, j);
            if (Similarity > Threshold) {
               AnsiString EdgeString = "    ";
               // <edge source="1" target="2"><label>NEO</label><style><line linewidth="5" linestyle="dotted" colour="blue"/></style></edge>
               EdgeString += "<edge source=\"" + NodeNamePrefix + IntToStr(i) + "\" target =\"" + NodeNamePrefix + IntToStr(j) + "\">";
               EdgeString += "<label>" + FloatToStrF(Similarity, ffFixed, 15, 2) + "</label>";
               EdgeString += "<style>";
               EdgeString += "<line linewidth=\"1\" linestyle=\"" + EdgeType + "\" colour=\"" + EdgeColor + "\" />";
               EdgeString += "</style>";
               EdgeString += "</edge>";
               OutputStringList->Add(EdgeString);
            }
        }
        fprintf(stderr, "\b\b\b\b\b\b%5.2f\%", i / (double)DataTable->GetNumberOfRows() * 100.0);
    }


    // OtÃ`FbN
    TList* CheckedIndexList = new TList();
    TList* ToCheckIndexList = new TList();
    TList* IsolatedIndexList = new TList();
    if (ShowIsolatedNodes) {
        for (int i = 0; i < DataTable->GetNumberOfRows(); i++) {
            if (isisolatednode(DataTable, Threshold, i)) {
                IsolatedIndexList->Add((void*)i);
            } else if (ToCheckIndexList->Count == 0) {
                ToCheckIndexList->Add((void*)i);
            }
        }
    } else if (DataTable->GetNumberOfRows() > 0) {
        ToCheckIndexList->Add((void*)0);
    }

    while (CheckedIndexList->Count + IsolatedIndexList->Count < DataTable->GetNumberOfRows()) {
        while (ToCheckIndexList->Count > 0) {
            int CheckingIndex = (int)ToCheckIndexList->Items[0];
            ToCheckIndexList->Delete(0);
            for (int i = 0; i < DataTable->GetNumberOfColumns(); i++) {
                if ((i != CheckingIndex)
                   && (IsolatedIndexList->IndexOf((void*)i) == -1)
                   && (DataTable->GetValueByIndex(CheckingIndex, i) > Threshold)
                   && (CheckedIndexList->IndexOf((void*)i) == -1)
                   && (ToCheckIndexList->IndexOf((void*)i) == -1)) {
                    ToCheckIndexList->Add((void*)i);
                }
            }
            CheckedIndexList->Add((void*)CheckingIndex);
        }

        // _~[GbW
        if (CheckedIndexList->Count + IsolatedIndexList->Count < DataTable->GetNumberOfRows()) {
            int SourceIndex = (int)CheckedIndexList->Items[CheckedIndexList->Count - 1];
            int DestIndex = SourceIndex;
            while (true) {
                DestIndex++;
                if (DestIndex >= DataTable->GetNumberOfColumns()) {
                    DestIndex = 0;
                }
                if ((DestIndex != SourceIndex)
                    && (IsolatedIndexList->IndexOf((void*)DestIndex) == -1)
                    && (CheckedIndexList->IndexOf((void*)DestIndex) == -1)) {
                    OutputStringList->Add("    <edge source=\"" + NodeNamePrefix + IntToStr(SourceIndex) + "\" target=\"" + NodeNamePrefix + IntToStr(DestIndex) + "\"><label></label><style><line linewidth=\"0\" linestyle=\"dotted\" colour=\"white\" /></style></edge>");
                    ToCheckIndexList->Add((void*)DestIndex);
                    break;
                }
            }
        }
    }
    delete IsolatedIndexList;
    delete CheckedIndexList;
    delete ToCheckIndexList;

    fprintf(stderr, "\b\b\b\b\b\b%5.2f\%\n", 100.0);
    OutputStringList->Add("");
    fprintf(stderr, "\n");
}

//---------------------------------------------------------------------------
void adduseritemedges(TStringList* OutputStringList, TCFbEPrimitiveTable* DataTable, TCFbEPrimitiveTable* UsersTable, TCFbEPrimitiveTable* ItemsTable, AnsiString UserLabelPrefix, AnsiString ItemLabelPrefix, AnsiString EdgeColor, AnsiString EdgeType)
{
    for (int i = 0; i < DataTable->GetNumberOfRows(); i++) {
        for (int j = 0; j < DataTable->GetNumberOfColumns(); j++) {
            if (DataTable->GetEnabledByIndex(i, j)) {
                int UserIndex = UsersTable->GetRowLabelList()->IndexOf(DataTable->GetRowLabelList()->Strings[i]);
                int ItemIndex = ItemsTable->GetRowLabelList()->IndexOf(DataTable->GetColumnLabelList()->Strings[j]);

                if ((UserIndex == -1) || (ItemIndex == -1)) {
                    continue;
                }

                AnsiString EdgeString = "    ";
                // <edge source="1" target="2"><label>NEO</label><style><line linewidth="5" colour="blue"/></style></edge>
                EdgeString += "<edge source=\"" + UserLabelPrefix + IntToStr(UserIndex) + "\" target =\"" + ItemLabelPrefix + IntToStr(ItemIndex) + "\">";
                EdgeString += "<label></label>";
                EdgeString += "<style>";
                EdgeString += "<line linewidth=\"1\" linestyle=\"" + EdgeType + "\" colour=\"" + EdgeColor + "\" />";
                EdgeString += "</style>";
                EdgeString += "</edge>";
                OutputStringList->Add(EdgeString);
            }
        }
        fprintf(stderr, "\b\b\b\b\b\b%5.2f\%", i / (double)DataTable->GetNumberOfRows() * 100.0);
    }
    fprintf(stderr, "\b\b\b\b\b\b%5.2f\%\n", 100.0);
    OutputStringList->Add("");
    fprintf(stderr, "\n");
}

//---------------------------------------------------------------------------
#pragma argsused
int main(int argc, char* argv[])
{
    fprintf(stderr, "\n======================================================================\n");
    fprintf(stderr, "%s", TCFbEToolkit::GetToolkit()->GetCopyrightStr("GraphMania").c_str());
    fprintf(stderr, "======================================================================\n");
    fprintf(stderr, "\n");
    if (argc != 7) {
       fprintf(stderr, "graphmania.exe sourcedata userssims itemssims threshold neighborssize showisolatednodes\n");
       fprintf(stderr, "  sourcedata: input file name of source data matrix\n");
       fprintf(stderr, "  userssims: input file name of users' similarities\n");
       fprintf(stderr, "  itemssims: input file name of items' similarities\n");
       fprintf(stderr, "  threshold: similarity threshold\n");
       fprintf(stderr, "  neighborssize: maximum # of edges per node, 0 denotes no limitation\n");
       fprintf(stderr, "  isolatednodes: if \"show\", isolated nodes are shown\n");
       fprintf(stderr, "\n");
       fprintf(stderr, "GraphMania unsuccessfully imcompleted the task.\n");
       fprintf(stderr, "\n");
       fprintf(stderr, "======================================================================\n");
       return 1;
    }

    TFileName SourceDataFileName = argv[1];
    TFileName UsersSimilaritiesFileName = argv[2];
    TFileName ItemsSimilaritiesFileName = argv[3];
    double Threshold = StrToFloat(argv[4]);
    int NeighborsSize = StrToInt(argv[5]);
    bool ShowIsolatedNodes = (AnsiString(argv[6]) == "show");

    AnsiString GraphName = ChangeFileExt(ExtractFileName(SourceDataFileName), "");
    AnsiString OutputXmlFileName = ChangeFileExt(SourceDataFileName, ".xml");
    AnsiString OutputHtmlFileName = ChangeFileExt(SourceDataFileName, ".html");

    TStringList* OutputStringList = new TStringList();
    OutputStringList->Add("<?xml version=\"1.0\"?>");
    OutputStringList->Add("");
    OutputStringList->Add("<!DOCTYPE GraphXML SYSTEM \"GraphXML.dtd\">");
    OutputStringList->Add("");
    OutputStringList->Add("<GraphXML>");
    OutputStringList->Add("  <graph id=\"" + GraphName + "\">");
    OutputStringList->Add("");

    fprintf(stderr, "(1/7) Loading the following files.\n");
    fprintf(stderr, "  \"%s\"\n", SourceDataFileName.c_str());
    fprintf(stderr, "  \"%s\"\n", UsersSimilaritiesFileName.c_str());
    fprintf(stderr, "  \"%s\"\n", ItemsSimilaritiesFileName.c_str());

    TStringList* InputFileStringList = new TStringList();
    InputFileStringList->LoadFromFile(SourceDataFileName);
    TCFbEPrimitiveTable* SourceDataTable = new TCFbEPrimitiveTable(InputFileStringList);
    delete InputFileStringList;

    TCFbEPrimitiveTable* UsersTable = loadtable(UsersSimilaritiesFileName, NeighborsSize);
    TCFbEPrimitiveTable* ItemsTable = loadtable(ItemsSimilaritiesFileName, NeighborsSize);
    trimnodes(UsersTable, ItemsTable, SourceDataTable, NeighborsSize, Threshold, ShowIsolatedNodes);

    fprintf(stderr, "    ..... completed.\n");
    fprintf(stderr, "\n");

    fprintf(stderr, "(2/7) Adding users' nodes:  0.00\%");
    addnodes(OutputStringList, UsersTable, "row_", "#000000", "#ffdddd", "row_image.png", "");

    fprintf(stderr, "(3/7) Adding items' nodes:  0.00\%");
    addnodes(OutputStringList, ItemsTable, "column_", "#000000", "#ddddff", "column_image.png", "");

    fprintf(stderr, "(4/7) Adding edges among users:  0.00\%");
    addedges(OutputStringList, UsersTable, Threshold, "row_", "#ff0000", "line", ShowIsolatedNodes);

    fprintf(stderr, "(5/7) Adding edges among items:  0.00\%");
    addedges(OutputStringList, ItemsTable, Threshold, "column_", "#0000ff", "line", ShowIsolatedNodes);

    fprintf(stderr, "(6/7) Adding edges between users and items:  0.00\%");
    adduseritemedges(OutputStringList, SourceDataTable, UsersTable, ItemsTable, "row_", "column_", "#bbbbbb", "line");

    OutputStringList->Add("  </graph>");
    OutputStringList->Add("</GraphXML>");

    fprintf(stderr, "(7/7) Saving the following files.\n");
    fprintf(stderr, "  \"%s\"\n", OutputXmlFileName.c_str());
    fprintf(stderr, "  \"%s\"\n", OutputHtmlFileName.c_str());
    OutputStringList->SaveToFile(OutputXmlFileName);

    OutputStringList->Clear();
    OutputStringList->Add("<html>");
    OutputStringList->Add("  <header>");
    OutputStringList->Add("    <title>" + GraphName + "</title>");
    OutputStringList->Add("  </header>");
    OutputStringList->Add("  <body>");
    OutputStringList->Add("    <applet code=\"hypergraph.applications.hexplorer.HExplorerApplet\" align=\"baseline\" archive=\"hyperapplet.jar\" width=\"640\" height=\"480\">");
    OutputStringList->Add("      <param name=\"file\" value=\"" + ExtractFileName(OutputXmlFileName) + "\">");
    OutputStringList->Add("    </applet>");
    OutputStringList->Add("  </body>");
    OutputStringList->Add("</html>");
    OutputStringList->SaveToFile(OutputHtmlFileName);

    fprintf(stderr, "    ..... completed.\n");
    fprintf(stderr, "\n");
    fprintf(stderr, "GraphMania successfully completed making a graph.\n");
    fprintf(stderr, "\n");
    fprintf(stderr, "======================================================================\n");

    delete SourceDataTable;
    delete UsersTable;
    delete ItemsTable;
    delete OutputStringList;
    
    return 0;
}

//---------------------------------------------------------------------------
