/*
    TCFbEAdjustedWeightedSumWithAverageOfNeighbors.cpp    June 6, 2004.

    Copyright (C) 2003-2005 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#pragma hdrstop

#include "TCFbEAdjustedWeightedSumWithAverageOfNeighbors.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------------
// RXgN^
__fastcall TCFbEAdjustedWeightedSumWithAverageOfNeighbors::TCFbEAdjustedWeightedSumWithAverageOfNeighbors(void)
    : TCFbEWeightedSum()
{
}

//---------------------------------------------------------------------------
// fXgN^
__fastcall TCFbEAdjustedWeightedSumWithAverageOfNeighbors::~TCFbEAdjustedWeightedSumWithAverageOfNeighbors()
{
}

//---------------------------------------------------------------------------
// ȍ~Cprotected \bh
//---------------------------------------------------------------------------
// LbVNA
void __fastcall TCFbEAdjustedWeightedSumWithAverageOfNeighbors::ClearCash(void)
{
    TCFbEWeightedSum::ClearCash();
    this->CashEnabled = false;
}

//---------------------------------------------------------------------------
// q̒l𓾂
double __fastcall TCFbEAdjustedWeightedSumWithAverageOfNeighbors::GetNumerator(int NeighborIndex, int TargetColumnIndex)
{
    if (!this->CashEnabled) {
        this->AverageOfNeighbors = TCFbENeighbor::GetAverageValueOfNeighborList(this->NeighborList);
    }

    TCFbENeighbor*    Neighbor = (TCFbENeighbor*)this->NeighborList->Items[NeighborIndex];
    return (Neighbor->GetValue() - this->AverageOfNeighbors) *  Neighbor->GetSimilarity();
}

//---------------------------------------------------------------------------
// \l𓾂
double __fastcall TCFbEAdjustedWeightedSumWithAverageOfNeighbors::GetPredictedValue(double Numerator, double Denominator)
{
    if (!this->CashEnabled) {
        this->AverageOfNeighbors = TCFbENeighbor::GetAverageValueOfNeighborList(this->NeighborList);
    }

    return this->AverageOfNeighbors + Numerator / Denominator;
}

//---------------------------------------------------------------------------

