/*
    TCFbEDocfbeCommandLineParser.cpp    June 6, 2004.

    Copyright (C) 2003-2005 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#pragma hdrstop

#include "TCFbEDocfbeCommandLineParser.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------------
// RXgN^iargc  argv ɂăR}hC^
__fastcall TCFbEDocfbeCommandLineParser::TCFbEDocfbeCommandLineParser(int argc, char* argv[])
    : TCFbECustomCommandLineParser(argc, argv)
{
    this->EstimatingDataFileNameList = new TStringList();
    this->PredictionName = "";
    this->NeighborsSize = 0;
    this->CaseAmplifier = 1.0;
    this->VWPredictionName = "";
    this->MergeBase = tmbBoth;
    this->DisplayNeighbors = false;
    this->DisplaySimilarities = false;
    this->DisplayValues = false;
    this->DisplayDistribution = false;
    this->Recommendation = false;
}

//---------------------------------------------------------------------------
__fastcall TCFbEDocfbeCommandLineParser::~TCFbEDocfbeCommandLineParser()
{
    delete this->EstimatingDataFileNameList;
}

//---------------------------------------------------------------------------
// wvԂ
AnsiString __fastcall TCFbEDocfbeCommandLineParser::GetHelpString(void)
{
    return
        //            0         1         2         3         4         5         6         7
        //            01234567890123456789012345678901234567890123456789012345678901234567890123456789
          AnsiString("USAGE:                                                                         \n")
        + AnsiString("  docfbe [OPTIONS] -l=FILENAMES -e=FILENAMES -s=ALGORITHM -p=ALGORITHM         \n")
        + AnsiString("\n")
        + AnsiString("where,                                                                         \n")
        + AnsiString("  -l, --learning=FILENAMES   Learning Data filenames separated by comma.       \n")
        + AnsiString("  -e, --estimating=FILENAMES Estimating Data filenames separated by comma.     \n")
        + AnsiString("  -s, --similarity=ALGORITHM Similarity computation algorithm.                 \n")
        + AnsiString("  -p, --prediction=ALGORITHM Prediction algorithm.                             \n")
        + AnsiString("\n")
        + AnsiString("OPTIONS are specified as:                                                      \n")
        + AnsiString("  -h, --help                 Display this help and exit.                       \n")
        + AnsiString("  -n, --normalize=METHOD     Method to normalize values. METHOD is specified as\n")
        + AnsiString("                             value | normalize | standardize | order           \n")
        + AnsiString("  -i, --itembased            Apply item-based collaborative filtering.         \n")
        + AnsiString("  -ns,--neighbors-size=SIZE  Neighbors size; i.e., how much similar rows will  \n")
        + AnsiString("                             be used for estimating.                           \n")
        + AnsiString("  -cs,--combined-similarity=ALGORITHM   Combined similarity computation        \n")
        + AnsiString("                                        algorithm is specified.                \n")
        + AnsiString("  -cr,--combined-ratio=RATIO Ratio of similarity calculated with combined      \n")
        + AnsiString("                             similarity algorithm in combining similarities.   \n")
        + AnsiString("  -d, --default=VALUE        Default value is put instead of missing values.   \n")
        + AnsiString("  -if,--inverse-frequency    Inverse Case Frequency is applied.                \n")
        + AnsiString("  -ca,--case-amplifier=VALUE Case Amplification is applied.                    \n")
        + AnsiString("  -vs,--vw-similarity=ALGORITHM   Variable Weighting is applied for similarity \n")
        + AnsiString("                                  computation.                                 \n")
        + AnsiString("  -vp,--vw-prediction=ALGORITHM   Variable Weighting is applied for prediction.\n")
        + AnsiString("  -t, --target=LABEL[,LABEL] Target columns to estimate. Unspecified denotes   \n")
        + AnsiString("                             all unknown columns will be estimated. Or \"*\"   \n")
        + AnsiString("                             indicates all columns will be estimated.          \n")
        + AnsiString("  -m, --merge=BASEDATA       Base dataset in merging data.  BASEDATA is        \n")
        + AnsiString("                             specified as: none | both | learning | estimating \n")
        + AnsiString("  -dn,--disp-neighbors       Display neighbors with the results.               \n")
        + AnsiString("  -ds,--disp-similarities    Display neighbors' similarities with the results. \n")
        + AnsiString("  -dv,--disp-values          Display neighbors' values with the results.       \n")
        + AnsiString("  -dd,--disp-distribution    Display distribution of the similarities.         \n")
        + AnsiString("  -r, --recommendation       Output as recommendation form.                    \n")
        + AnsiString("  -o, --output=FILENAME      File name for outputting the results.             \n")
        + AnsiString("\n")
        + AnsiString("Similarity computation algorithm and variable weighting algorithm are specified\n")
        + AnsiString("as one of the following terms:                                                 \n")
        + AnsiString("  CosineSimilarity                                                             \n")
        + AnsiString("  AdjustedCosineSimilarityWithAverage                                          \n")
        + AnsiString("  AdjustedCosineSimilarityWithMedian                                           \n")
        + AnsiString("  CorrelationCoefficientWithAverage                                            \n")
        + AnsiString("  CorrelationCoefficientWithMedian                                             \n")
        + AnsiString("  RankCorrelation                                                              \n")
        + AnsiString("  DistanceSimilarityWithAverage                                                \n")
        + AnsiString("  DistanceSimilarityWithMedian                                                 \n")
        + AnsiString("\n")
        + AnsiString("Prediction algorithm is specified as one of the following terms:               \n")
        + AnsiString("  WeightedSum                                                                  \n")
        + AnsiString("  AdjustedWeightedSumWithAverageOfColumn                                       \n")
        + AnsiString("  AdjustedWeightedSumWithMedianOfColumn                                        \n")
        + AnsiString("  AdjustedWeightedSumWithAverageOfNeighbors                                    \n")
        + AnsiString("  AdjustedWeightedSumWithMedianOfNeighbors                                     \n")
        + AnsiString("  AdjustedWeightedSumWithAverageOfRow                                          \n")
        + AnsiString("  AdjustedWeightedSumWithMedianOfRow                                           \n")
        + AnsiString("  AmplifiedWeightedSumWithAveragedMultiplier                                   \n")
        + AnsiString("  AmplifiedWeightedSumWithMedianOfMultiplier                                   \n")
        + AnsiString("  AmplifiedWeightedSumWithVWWeightedMultiplier                                 \n")
        + AnsiString("\n")
        + AnsiString("EXAMPLES:                                                                      \n")
        + AnsiString("  docfbe -l=learning.csv -e=estimating.csv -s=CosineSimilarity -p=WeightedSum  \n")
        + AnsiString("\n")
        + AnsiString("  docfbe --learning=learning.csv --estimating=estimating.csv --similarity=Cosin\n")
        + AnsiString("  eSimilarity --prediction=WeightedSum                                         \n")
        + AnsiString("\n")
        + AnsiString("  docfbe -n=normalize -i -ns=10 -t=BUG,EFFORT -dn -ds -dd -o=output.txt -l=lear\n")
        + AnsiString("  ning.csv -e=estimating.csv -s=CosineSimilarity -p=WeightedSum                \n")
        + AnsiString("\n")
        + AnsiString("  docfbe --normalize=normalize --itembased --neighbors-size=10 --target=BUG,EFF\n")
        + AnsiString("  ORT --disp-neighbors --disp-similarities --disp-distribution --output=output.\n")
        + AnsiString("  txt --learning=learning.csv --estimating=estimating.csv --similarity=CosineSi\n")
        + AnsiString("  milarity --prediction=WeightedSum                                            \n");
}

//---------------------------------------------------------------------------
// R}hCp[XăG[R[hԂ
int __fastcall TCFbEDocfbeCommandLineParser::DoParse(void)
{
    if (TCFbECustomCommandLineParser::DoParse() != ecNone) {
        return this->ErrorCode; // ɃG[oĂ
        
    } else if (this->HelpEnabled) { // wvĂяo
        return ecNone;
    }

    // K{p[^w肳Ă邩ǂ`FbN
    if (this->EstimatingDataFileNameList->Count <= 0) {
        this->ErrorCode = ecNoEstimatingDataFileName;

    } else if (this->PredictionName.IsEmpty()) {
        this->ErrorCode = ecNoPredictionAlgorithm;

    } else if ((this->PredictionName == "AmplifiedWeightedSumWithVWWeightedMultiplier") && this->VWPredictionName.IsEmpty()) {
        this->ErrorCode = ecNoVWPredictionAlgorithm;
        this->ErrorParameter = "";
    }

    return this->ErrorCode;
}

//---------------------------------------------------------------------------
// Option  Parameter ƋɊώ@ꂽƂ񍐂D
bool __fastcall TCFbEDocfbeCommandLineParser::OptionObserved(AnsiString Option, AnsiString Parameter)
{
    // YIvVɂĂ̏͐e
    if (TCFbECustomCommandLineParser::OptionObserved(Option, Parameter)) {
        return true;
    }

    // -e, --estimating p[^̌
    if (this->OptionNameIs(Option, "-e", "--estimating")) {
        this->EstimatingDataFileNameList->DelimitedText = Parameter;
        for (int k = 0; k < this->EstimatingDataFileNameList->Count; k++) {
            if (!FileExists(this->EstimatingDataFileNameList->Strings[k])) {
                this->ErrorCode = ecEstimatingDataNotFound;
                this->ErrorParameter = this->EstimatingDataFileNameList->Strings[k];
                break;
            }
        }

    // -p, --prediction p[^̌
    } else if (this->OptionNameIs(Option, "-p", "--prediction")) {
        this->PredictionName = Parameter;
        TCFbEPredictionAlgorithm* PA = CreatePredictionAlgorithm(this->PredictionName);
        if (PA == NULL) {
            this->ErrorCode = ecIllegalPredictionAlgorithm;
            this->ErrorParameter = this->PredictionName;
        }
        delete PA;

    // -ns,--neighbors-size p[^̌
    } else if (this->OptionNameIs(Option, "-ns", "--neighbors-size")) {
        try {
            this->NeighborsSize = Parameter.ToInt();
        } catch (EConvertError &ece) {
            this->ErrorCode = ecIllegalNeighborsSize;
            this->ErrorParameter = Parameter;
        }

    // -ca,--case-amplifier p[^̌
    } else if (this->OptionNameIs(Option, "-ca", "--case-amplifier")) {
        try {
            this->CaseAmplifier = Parameter.ToDouble();
        } catch (EConvertError &ece) {
            this->ErrorCode = ecIllegalCaseAmplifier;
            this->ErrorParameter = Parameter;
        }

    // -vp, --vw-prediction p[^̌
    } else if (this->OptionNameIs(Option, "-vp", "--vw-prediction")) {
        this->VWPredictionName = Parameter;
        TCFbESimilarityComputationAlgorithm* VWPA = this->CreateSimilarityComputationAlgorithm(this->VWPredictionName);
        if (VWPA == NULL) {
            this->ErrorCode = ecIllegalVWPredictionAlgorithm;
            this->ErrorParameter = this->VWPredictionName;
        } else if (this->PredictionName != "AmplifiedWeightedSumWithVWWeightedMultiplier") {
            this->ErrorCode = ecVWPredictionAlgorithmIllegallySpecified;
            this->ErrorParameter = this->PredictionName;
        }
        delete VWPA;

    // -m, --merge p[^̌
    } else if (this->OptionNameIs(Option, "-m", "--merge")) {
        if (Parameter.AnsiCompareIC("both") == 0) {
            this->MergeBase = tmbBoth;
        } else if (Parameter.AnsiCompareIC("none") == 0) {
            this->MergeBase = tmbNone;
        } else if (Parameter.AnsiCompareIC("learning") == 0) {
            this->MergeBase = tmbLearningData;
        } else if (Parameter.AnsiCompareIC("estimating") == 0) {
            this->MergeBase = tmbEstimatingData;
        } else {
            this->ErrorCode = ecIllegalMergeBase;
            this->ErrorParameter = Parameter;
        }

    // -dn, --disp-neighbors p[^̌
    } else if (this->OptionNameIs(Option, "-dn", "--disp-neighbors")) {
        this->DisplayNeighbors = true;

    // -ds, --disp-similarities p[^̌
    } else if (this->OptionNameIs(Option, "-ds", "--disp-similarities")) {
        this->DisplaySimilarities = true;

    // -dv, --disp-values p[^̌
    } else if (this->OptionNameIs(Option, "-dv", "--disp-values")) {
        this->DisplayValues = true;

    // -dd, --disp-distribution p[^̌
    } else if (this->OptionNameIs(Option, "-dd", "--disp-distribution")) {
        this->DisplayDistribution = true;

    // -r, --recommendation p[^̌
    } else if (this->OptionNameIs(Option, "-r", "--recommendation")) {
        this->Recommendation = true;

    } else {
        return false;   // ߕs\
    }

    return true;
}

//---------------------------------------------------------------------------

