/*
    simfinder.cpp    January 13, 2005.

    Copyright (C) 2003-2005 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#pragma hdrstop
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <SysUtils.hpp>
#include <stdio.h>

#include "EDocfbeError.h"
#include "TCFbEToolkit.h"
#include "TCFbESimfinderCommandLineParser.h"
#include "TCFbESimfinderDataLoader.h"

#include "TCFbEDataSetEx.h"
#include "TCFbESimilarityComputationAlgorithm.h"
#include "TCFbEPredictionAlgorithm.h"

#include "TCFbESimfinderOutputCache.h"
//---------------------------------------------------------------------------
#pragma argsused
//---------------------------------------------------------------------------
//
int main(int argc, char* argv[])
{
    // Rs[Cg\
    fprintf(stderr, "\n======================================================================\n");
    fprintf(stderr, "%s", TCFbEToolkit::GetToolkit()->GetCopyrightStr("CF based Similarity Analysis"));
    fprintf(stderr, "======================================================================\n");

    try {
        //------------------------------------------------------------
        // R}hC߂
        TCFbESimfinderCommandLineParser* Parser;
        Parser = new TCFbESimfinderCommandLineParser(argc, argv);
        try {
            Parser->DoParse();
        } catch (Exception& e) {
            throw EDocfbeError(-13, "Commandline Parsing", e.Message);
        }

        if (Parser->ErrorCode != 0) {    // G[
            throw EDocfbeError(Parser->ErrorCode, Parser->ErrorParameter, "");
        }

        if (Parser->HelpEnabled) {    // wv\
            fprintf(stderr, "%s", Parser->GetHelpString().c_str());

            // I
            TCFbEToolkit::DeleteToolkit();

            fprintf(stderr, "======================================================================\n");
            return 0;
        }

        fprintf(stderr, "CF based Similarity Analysis is started.\n\n");

        //------------------------------------------------------------
        // f[^
        TCFbESimfinderDataLoader* DataLoader;
        try {
            DataLoader = new TCFbESimfinderDataLoader(Parser, true, 3, 1);
        } catch (Exception &e) {
            delete Parser;
            throw EDocfbeError(-13, "Data Loading", e.Message);
        }

        if (DataLoader->ErrorCode != 0) {    // G[
            throw EDocfbeError(DataLoader->ErrorCode, DataLoader->ErrorParameter, "");
        }

        //------------------------------------------------------------
        // tB^OsCΏۃgNX\
        TCFbESimfinderOutputCache* OutputCache;
        try {
            OutputCache = new TCFbESimfinderOutputCache(Parser, DataLoader, true);
        } catch (Exception &e) {
            delete Parser;
            delete DataLoader;
            throw EDocfbeError(-13, "Similarity analysis", e.Message);
        }           

        //------------------------------------------------------------
        // ʂt@CCႵ́CWo͂ɏo
        fprintf(stderr, "(3/3) Outputting results to ");

        if (Parser->OutputFileName.IsEmpty()) {    // Wo͂ɏo
            fprintf(stderr, "STDOUT\n");
            fprintf(stdout, "%s\n", OutputCache->GetOutputStringList()->Text.c_str());
        } else {    // t@Cɕۑ
            fprintf(stderr, "\"%s\"\n", Parser->OutputFileName);
            try {
                OutputCache->GetOutputStringList()->SaveToFile(Parser->OutputFileName);
            } catch (EFCreateError &efce) {
                throw EDocfbeError(-12, Parser->OutputFileName, efce.Message);
            }
        }

        delete OutputCache;
        delete Parser;
        delete DataLoader;

        fprintf(stderr, "    ..... completed: 100.00\%\n\n");
        fprintf(stderr, "CF based Similarity Analysis is successfully completed.\n");

    } catch (EDocfbeError &ede) {    // ُIO󂯎 catch
        fprintf(stderr, "\n\nCF based Similarity Analysis terminated unsuccessfully with the following error.");
        fprintf(stderr, "\n\nError Code %d %s\n\n", ede.ErrorCode, ede.Message);
        fprintf(stderr, "======================================================================\n");
        return ede.ErrorCode;
        
    } catch (...) {
        throw;
    }

    // I
    TCFbEToolkit::DeleteToolkit();

    fprintf(stderr, "======================================================================\n");
    
    return 0;
}

//---------------------------------------------------------------------------
