using System;
using System.Collections.Generic;
using System.ComponentModel;

namespace NDac.Datas.Extensions
{
	/// <summary>
	/// データセットホルダーのコンテナを表します。
	/// </summary>
	class DataSetHolderContainer : IContainer
	{
		private List< IComponent >	_components;
		private bool				_isDisposed;

		/// <summary>
		/// コンストラクタ
		/// </summary>
		public DataSetHolderContainer()
		{
			this._components = new List< IComponent >();

			this._isDisposed = false;
		}

		/// <summary>
		/// デストラクタ
		/// </summary>
		~DataSetHolderContainer()
		{
			this.Dispose();
		}

		#region IContainer メンバ

		/// <summary>
		/// コンポーネントを追加します。
		/// </summary>
		/// <param name="component">コンポーネント</param>
		/// <param name="name">コンポーネント名</param>
		public void Add( IComponent component, string name )
		{
			this._components.Add( component );
		}

		/// <summary>
		/// コンポーネントを追加します。
		/// </summary>
		/// <param name="component">コンポーネント</param>
		public void Add( IComponent component )
		{
			this._components.Add( component );
		}

		/// <summary>
		/// コンポーネントのコレクションを表します。
		/// </summary>
		public ComponentCollection Components
		{
			get
			{
				return( new ComponentCollection( this._components.ToArray() ) );
			}
		}

		/// <summary>
		/// コンポーネントを削除します。
		/// </summary>
		/// <param name="component">削除するコンポーネント</param>
		public void Remove( IComponent component )
		{
			this._components.Remove( component );
		}

		#endregion

		#region IDisposable メンバ

		/// <summary>
		/// リソースの解放を行います。
		/// </summary>
		public void Dispose()
		{
			if( !this._isDisposed )
			{
				this._components.Clear();

				this._isDisposed = true;
			}
		}

		#endregion
	}
}
