using System;
using System.Text;
using System.Data;

namespace NDac.Datas.QueryGenerators
{
	/// <summary>
	/// DELETEクエリ生成器を表します。
	/// </summary>
	class DeleteQueryGenerator : IQueryGenerator
	{
		#region IQueryGenerator メンバ

		/// <summary>
		/// クエリを生成します。
		/// </summary>
		/// <param name="row">データ行</param>
		/// <param name="schemaTable">テーブルのスキーマ情報</param>
		/// <returns>クエリ</returns>
		public string Generate( DataRow row, DataTable schemaTable )
		{
			StringBuilder builder = new StringBuilder();

			bool mustJoint = false;

			builder.Append( string.Format( "DELETE FROM {0} WHERE ", schemaTable.TableName ) );

			foreach( DataColumn column in schemaTable.PrimaryKey )
			{
				if( row[ column.ColumnName ] != DBNull.Value )
				{
					if( mustJoint )
					{
						builder.Append( " AND " );
					}

					builder.Append( QueryGenerateHelper.ToWhereConditionString( column, row ) );

					mustJoint = true;
				}
			}

			return( builder.ToString() );
		}

		#endregion
	}
}
