using System.Collections.Generic;
using System.Data;

namespace NDac.Datas.QueryGenerators
{
	/// <summary>
	/// クエリ生成器のマネージャを表します。
	/// </summary>
	class QueryGeneratorManager
	{
		private static QueryGeneratorManager _instance;
		private Dictionary< DataRowState, IQueryGenerator > _generators;

		/// <summary>
		/// コンストラクタ
		/// </summary>
		private QueryGeneratorManager()
		{
			this._generators = new Dictionary< DataRowState, IQueryGenerator >();

			this._generators.Add( DataRowState.Added,		new InsertQueryGenerator() );

			this._generators.Add( DataRowState.Modified,	new UpdateQueryGenerator() );

			this._generators.Add( DataRowState.Deleted,		new DeleteQueryGenerator() );
		}

		/// <summary>
		/// インスタンスを表します。
		/// </summary>
		public static QueryGeneratorManager Instance
		{
			get
			{
				if( _instance == null )
				{
					_instance = new QueryGeneratorManager();
				}

				return( _instance );
			}
		}

		/// <summary>
		/// インデクサ
		/// </summary>
		/// <param name="rowState">DataRowオブジェクトの状態</param>
		/// <returns>DataRowオブジェクトの状態に該当するクエリ生成器</returns>
		public IQueryGenerator this[ DataRowState rowState ]
		{
			get
			{
				return( this._generators[ rowState ] );
			}
		}

		/// <summary>
		/// DataRowオブジェクトの状態に該当するクエリ生成器が存在するかを判定します。
		/// </summary>
		/// <param name="rowState">DataRowオブジェクトの状態</param>
		/// <returns>DataRowオブジェクトの状態に該当するクエリ生成器が存在する場合trueが返ります。</returns>
		public bool HasGenerator( DataRowState rowState )
		{
			return( this._generators.ContainsKey( rowState ) );
		}
	}
}
