using System;
using System.Data;
using System.Data.SqlClient;
using NDac.Datas;
using NDac.Keys;

namespace NDac.Gateways
{
	/// <summary>
	/// IdNumberingテーブルのゲートウェイを表します。
	/// </summary>
	public partial class IdNumberingGateway : TableDataGateway< IdNumberingKey >
	{
		private const string TABLE_NAME = "IdNumbering";

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="connectionString">接続文字列</param>
		public IdNumberingGateway( string connectionString )
			: base( TABLE_NAME, connectionString )
		{
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="holder">データセットホルダー</param>
		public IdNumberingGateway( DataSetHolder holder )
			: base( TABLE_NAME, holder )
		{
		}

		/// <summary>
		/// アクセスするテーブル名を表します。
		/// </summary>
		public static string AccessTableName
		{
			get
			{
				return( TABLE_NAME );
			}
		}

		/// <summary>
		/// キー情報に一致したレコードが存在するかを判定します。
		/// </summary>
		/// <param name="tableName">TableName</param>
		/// <returns>キー情報に一致したレコードが存在する場合trueを返します。</returns>
		public bool HasValue( string tableName )
		{
			return( this.HasValue( new IdNumberingKey( tableName ) ) );
		}

		/// <summary>
		/// キー情報に一致したレコードが存在するかを判定します。
		/// </summary>
		/// <param name="primaryKey">プライマリキー</param>
		/// <returns>キー情報に一致したレコードが存在する場合trueを返します。</returns>
		public override bool HasValue( IdNumberingKey primaryKey )
		{
			string sql = string.Format( "SELECT TOP 1 * FROM {0} WHERE ( TableName = @TableName )", this.TableName );	//HasValueは"SELECT TOP 1"で統一

			SqlCommand selectCommand = new SqlCommand( sql );

			selectCommand.Parameters.Add( new SqlParameter( "@TableName", primaryKey.TableName ) );

			return( this.Holder.HasRecord( selectCommand ) );
		}

		/// <summary>
		/// キー情報に一致したデータを充填します。
		/// </summary>
		/// <param name="tableName">TableName</param>
		public void LoadBy( string tableName )
		{
			this.LoadBy( new IdNumberingKey( tableName ) );
		}

		/// <summary>
		/// キー情報に一致したデータを充填します。
		/// </summary>
		/// <param name="primaryKey">プライマリキー</param>
		public override void LoadBy( IdNumberingKey primaryKey )
		{
			string sql = string.Format( "SELECT * FROM {0} WHERE ( TableName = @TableName )", this.TableName );

			SqlCommand selectCommand = new SqlCommand( sql );

			selectCommand.Parameters.Add( new SqlParameter( "@TableName", primaryKey.TableName ) );

			this.Holder.FillData( this.TableName, selectCommand );
		}

		/// <summary>
		/// キー情報に一致したデータを追加充填します。
		/// </summary>
		/// <param name="tableName">TableName</param>
		public void MoreLoadBy( string tableName )
		{
			this.MoreLoadBy( new IdNumberingKey( tableName ) );
		}

		/// <summary>
		/// キー情報に一致したデータを追加充填します。
		/// </summary>
		/// <param name="primaryKey">プライマリキー</param>
		public override void MoreLoadBy( IdNumberingKey primaryKey )
		{
			string sql = string.Format( "SELECT * FROM {0} WHERE ( TableName = @TableName )", this.TableName );

			SqlCommand selectCommand = new SqlCommand( sql );

			selectCommand.Parameters.Add( new SqlParameter( "@TableName", primaryKey.TableName ) );

			this.Holder.MoreFillData( this.TableName, selectCommand );
		}
	}
}
