using System;
using System.Reflection;

namespace NDac.Keys
{
	/// <summary>
	/// キーの抽象クラスを表します。
	/// </summary>
	public abstract class Key : IKey
	{
		/// <summary>
		/// ==演算子を表します。
		/// </summary>
		/// <param name="leftOperand">左辺オペランド</param>
		/// <param name="rightOperand">右辺オペランド</param>
		/// <returns>値が等しい場合trueを返します。</returns>
		public static bool operator ==( Key leftOperand, Key rightOperand )
		{
			return( ValueVerifier.IsEquals( leftOperand, rightOperand ) );
		}

		/// <summary>
		/// !=演算子を表します。
		/// </summary>
		/// <param name="leftOperand">左辺オペランド</param>
		/// <param name="rightOperand">右辺オペランド</param>
		/// <returns>値が等しくない場合trueを返します。</returns>
		public static bool operator !=( Key leftOperand, Key rightOperand )
		{
			return( leftOperand == rightOperand ? false : true );
		}

		/// <summary>
		/// インスタンスが等しいかどうかを判断します。
		/// </summary>
		/// <param name="obj">比較対象のインスタンス</param>
		/// <returns>インスタンスが等しい場合trueを返します。</returns>
		public override bool Equals( object obj )
		{
			try
			{
				return( ValueVerifier.IsEquals( this, obj ) );
			}
			catch
			{
				return( false );
			}
		}

		/// <summary>
		/// ハッシュコードを取得します。
		/// </summary>
		/// <returns>ハッシュコード</returns>
		public override int GetHashCode()
		{
			return( ValueVerifier.GetHashCode( this ) );
		}

		#region IEquatable<IKey> メンバ

		/// <summary>
		/// 指定したインスタンスが現在のインスタンスと等しいかどうかを判断します。
		/// </summary>
		/// <param name="other">比較対象のインスタンス</param>
		/// <returns>指定したインスタンスが現在のインスタンスと等しい場合trueを返します。</returns>
		public bool Equals( IKey other )
		{
			return( ValueVerifier.IsEquals( this, other ) );
		}

		#endregion
	}
}
