using System;
using System.ComponentModel;
using System.Data;

namespace NDac.Modules.Extensions
{
	/// <summary>
	/// データテーブルのコンポーネントを表します。
	/// </summary>
	class DataTableComponent : IComponent
	{
		private ISite					_site;
		private DeletedRowTableManager	_deletedRowTableManager;
		private bool					_isDisposed;

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="table">データテーブル</param>
		public DataTableComponent( DataTable table )
		{
			this._deletedRowTableManager = new DeletedRowTableManager( table );

			this._isDisposed = false;
		}

		/// <summary>
		/// デストラクタ
		/// </summary>
		~DataTableComponent()
		{
			this.Dispose();
		}

		/// <summary>
		/// 削除された行を管理しているテーブルのマネージャを表します。
		/// </summary>
		public DeletedRowTableManager DeletedRowTableManager
		{
			get
			{
				return( this._deletedRowTableManager );
			}
		}

		#region IComponent メンバ

		public event EventHandler Disposed;

		/// <summary>
		/// サイトを表します。
		/// </summary>
		public ISite Site
		{
			get
			{
				return( this._site );
			}
			set
			{
				this._site = value;
			}
		}

		#endregion

		#region IDisposable メンバ

		/// <summary>
		/// リソースの解放を行います。
		/// </summary>
		public void Dispose()
		{
			if( !this._isDisposed )
			{
				this._site = null;

				this._deletedRowTableManager.Dispose();

				if( this.Disposed != null )
				{
					this.Disposed( this, new EventArgs() );
				}

				this._isDisposed = true;
			}
		}

		#endregion
	}
}
