﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.SqlClient;
using NDac.Keys;

namespace NDac.Gateways
{
	partial class BookGateway
	{
		/// <summary>
		/// キー情報に一致したデータを充填します。
		/// </summary>
		/// <param name="selectKey">ISBNコード検索キー</param>
		public void LoadBy( IsbnSelectKey selectKey )
		{
			string sql = string.Format( "SELECT TOP 1 * FROM {0} WHERE ( Isbn = @Isbn )", this.TableName );

			SqlCommand selectCommand = new SqlCommand( sql );

			selectCommand.Parameters.Add( new SqlParameter( "@Isbn", selectKey.Isbn ) );

			this.Holder.FillData( this.TableName, selectCommand );
		}

		/// <summary>
		/// キー情報に一致したデータを充填します。
		/// </summary>
		/// <param name="selectKey">名称検索キー</param>
		public void LoadBy( NameSelectKey selectKey )
		{
			string sql = string.Format( "SELECT TOP 1 * FROM {0} WHERE ( Title = @Title )", this.TableName );

			SqlCommand selectCommand = new SqlCommand( sql );

			selectCommand.Parameters.Add( new SqlParameter( "@Title", selectKey.Name ) );

			this.Holder.FillData( this.TableName, selectCommand );
		}

		/// <summary>
		/// キー情報に一致したデータを充填します。
		/// </summary>
		/// <param name="selectKey">名称あいまい検索キー</param>
		public void LoadBy( NameLikeSelectKey selectKey )
		{
			string sql = string.Format( "SELECT TOP 1 * FROM {0} WHERE ( Title LIKE @Title )", this.TableName );

			SqlCommand selectCommand = new SqlCommand( sql );

			selectCommand.Parameters.Add( new SqlParameter( "@Title", selectKey.Name ) );

			this.Holder.FillData( this.TableName, selectCommand );
		}

		/// <summary>
		/// キー情報に一致したデータを充填します。
		/// </summary>
		/// <param name="selectKey">出版社名検索キー</param>
		public void LoadBy( PublisherNameLikeSelectKey selectKey )
		{
			string sql = string.Format( "SELECT {0}.* FROM {0}, {1} WHERE ( {0}.PublisherId = {1}.Id ) AND ( {1}.Name LIKE @Name )", this.TableName, PublisherGateway.AccessTableName );

			SqlCommand selectCommand = new SqlCommand( sql );

			selectCommand.Parameters.Add( new SqlParameter( "@Name", selectKey.Name ) );

			this.Holder.FillData( this.TableName, selectCommand );
		}
	}
}
