/* bZ[W{bNX}l[W */

#include "bootpack.h"

struct TASK *mpmtask;
struct SHEET *mpmsht;

void run_mpm(void)
{	
	int *keyfifo = (int *)memman_alloc_4k(128 * 4);

	mpmtask = task_alloc();
	mpmtask->tss.esp = memman_alloc_4k(64 * 1024) + 64 * 1024;
	mpmtask->tss.eip = (int) &task_mpm;
	mpmtask->tss.es = 1 * 8;
	mpmtask->tss.cs = 2 * 8;
	mpmtask->tss.ss = 1 * 8;
	mpmtask->tss.ds = 1 * 8;
	mpmtask->tss.fs = 1 * 8;
	mpmtask->tss.gs = 1 * 8;
	task_run(mpmtask, 2, 1, "mpm");
	fifo32_init(&mpmtask->fifo, 128, keyfifo, mpmtask);

	return;
}

void stop_mpm(void)
{
	task_sleep(mpmtask);
	memman_free_4k(mpmtask->tss.esp, 64 * 1024);
	memman_free_4k((int)mpmtask->fifo.buf, 128 * 4);
	mpmtask->flags = 0;
	return;
}

void task_mpm(void)
{
	struct TASK *task = task_now();
	int i;
	
	for (;;) {
		io_cli();
		if (fifo32_status(&task->fifo) == 0) {
			task_sleep(task);
			io_sti();
		} else {
			i = fifo32_get(&task->fifo);
			io_sti();
			if (256 <= i && i <= 511) { /* L[{[hf[^i^XNAoRj */
				if (i == 'y' + 256 || i == 'Y' + 256) {
					close_mesbox();
				} else if (i == 'n' + 256 || i == 'N' + 256) {
					close_mesbox();
				}
			}			
		}
	}
}

void close_mesbox(void)
{
	struct SHTCTL *shtctl = (struct SHTCTL *) *((int *) 0x0fe4);
	struct SHEET *back;
	
	memman_free_4k((int)mpmsht, 500 * 150);
	sheet_free(mpmsht);
	keywin_off(mpmsht);
	if (shtctl->top > 1) {
		back = shtctl->sheets[shtctl->top - 1];
		keywin_on(back);
	}
	
	return;
}

void show_mesbox(char *caption, char *message)
{
	int wx, wy;
	UCHAR *buf = (UCHAR *)memman_alloc_4k(500 * 150);
	struct BOOTINFO *binfo = (struct BOOTINFO *) ADR_BOOTINFO;
	struct SHTCTL *shtctl = (struct SHTCTL *) *((int *) 0x0fe4);
	
	mpmsht = sheet_alloc();
	sheet_setbuf(mpmsht, buf, 500, 	150, -1);
	draw_window8(buf, 500, 150, caption, 0);
	mpmsht->task = mpmtask;
	
	/* ʒɕ\ */
	wx = (binfo->scrnx - 500) / 2;
	wy = (binfo->scrny - 150) / 2;
	sheet_slide(mpmsht, wx, wy);
	sheet_updown(mpmsht, shtctl->top);
	if (shtctl->active != 0) {
		keywin_off(shtctl->active);
	}
	keywin_on(mpmsht);
	
	return;
}

