/* VA|[g֌W */
/* Linux\[XĂĂ邪AƂ܂悭Ȃ */
/* IRQ̊荞ݔԍCOM1-4ACOM2-3ACOM3-4ACOM4-3炵   */
/* qemuAmFς                                    */

#include "bootpack.h"

#define SERIAL_COM1	0x3f8
#define	SERIAL_COM2	0x2f8
#define SERIAL_COM3	0x3e8
#define	SERIAL_COM4	0x2e8

/* VA|[gŎgWX^ */
/* ȂR炵BڂOSRC */
struct serial_registers {
	int thr;	/* Transmitter Holding Buffer	= 0 : Write 	*/
	int rbr;	/* Receiver Buffer 				= 0 : Read 		*/
	int dll;	/* Divisor Latch Low Byte		= 0 : Read/Write*/
	int ier;	/* Interrupt Enable Registe 	= 1 : Read/Write*/
	int dlm;	/* Divisor Latch High Byte 		= 1 : Read/Write*/
	int iir;	/* Interrupt Identif.. Register = 2 : Read 		*/
	int fcr;	/* FIFO Control Register 		= 2 : Write 	*/
	int lcr;	/* Line Control Register 		= 3 : Read/Write*/
	int mcr;	/* Modem Control Register 		= 4 : Read/Write*/
	int lsr;	/* Line Status Register 		= 5 : Read 		*/
	int msr;	/* Modem Status Register 		= 6 : Read 		*/
	int scr;	/* Scratch Register 			= 7 : Read/Write*/
};

static struct serial_registers reg[4]={
	{SERIAL_COM1+0,SERIAL_COM1+0,SERIAL_COM1+0,SERIAL_COM1+1,SERIAL_COM1+1,SERIAL_COM1+2,
	SERIAL_COM1+2,SERIAL_COM1+3,SERIAL_COM1+4,SERIAL_COM1+5,SERIAL_COM1+6,SERIAL_COM1+7},
	{SERIAL_COM2+0,SERIAL_COM2+0,SERIAL_COM2+0,SERIAL_COM2+1,SERIAL_COM2+1,SERIAL_COM2+2,
	SERIAL_COM2+2,SERIAL_COM2+3,SERIAL_COM2+4,SERIAL_COM2+5,SERIAL_COM2+6,SERIAL_COM2+7},
	{SERIAL_COM3+0,SERIAL_COM3+0,SERIAL_COM3+0,SERIAL_COM3+1,SERIAL_COM3+1,SERIAL_COM3+2,
	SERIAL_COM3+2,SERIAL_COM3+3,SERIAL_COM3+4,SERIAL_COM3+5,SERIAL_COM3+6,SERIAL_COM3+7},
	{SERIAL_COM4+0,SERIAL_COM4+0,SERIAL_COM4+0,SERIAL_COM4+1,SERIAL_COM4+1,SERIAL_COM4+2,
	SERIAL_COM4+2,SERIAL_COM4+3,SERIAL_COM4+4,SERIAL_COM4+5,SERIAL_COM4+6,SERIAL_COM4+7},	
};

/* VA|[g̗L */
/* retrun : 0 no uart,1 : 8250, 2 : 16450, 3 : 16550A, 4 : 16750 */
int detect_serialport(int com)
{
	int value;
	
	io_out8(reg[com].mcr, 0x10);
	if((io_in8(reg[com].msr) & 0xf0) != 0) return 0;
	io_out8(reg[com].mcr, 0x1f);
	if((io_in8(reg[com].msr) & 0xf0) != 0xf0) return 0;

	io_out8(reg[com].scr, 0x55);
	if(io_in8(reg[com].scr) != 0x55) return 1;
	io_out8(reg[com].scr, 0xaa);
	if(io_in8(reg[com].scr) != 0xaa) return 1;

	io_out8(reg[com].fcr, 0x21);
	value = io_in8(reg[com].iir);
	if ((value & 0xc0) != 0xc0) return 2;
	if ((value & 0x20) != 0x20) return 3;
	return 4;
}

/* VA|[g̏ */
void init_serialport(int com, int div)
{	
	io_out8(reg[com].lcr, 0x80);
	io_out8(reg[com].dll, div);	/* ʐMx 0x06 = 19200 0x01 = 115200 */
	io_out8(reg[com].lcr, 0x03);	/* CRg[ 8bit */
	io_out8(reg[com].mcr, 0x0b);	/* pin */
	io_out8(reg[com].ier, 0);		/* 荞ݖ */
	return;
}

/* VA|[gɃLN^M */
void send_char_serialport(int com, char c)
{
	io_out8(reg[com].thr, (int)c);
	return;
}

/* VA|[gɕ񑗐M */
void send_string_serialport(int com, char *string)
{
	int j;
	
	for (j = 0;string[j] != 0;j++) 
		send_char_serialport(com, string[j]);
	
	return;
}

/* VA|[g̃Xe[^X
	bit0 = 1	: LN^M
	bit6 = 1	: LN^𑗐M
	bit1 = 1	: Overrun error
	bit2 = 1	: Parity error
	bit3 = 1	: Framing error
*/
int receive_stat_serialport(int com)
{
	return io_in8(reg[com].lsr);
}

/* VA|[gLN^M */
char recv_char_serialport(int com)
{
	return io_in8(reg[com].rbr);
}

/* Ƃ肠̂Ƃ̓R[ĥʓ|Ȃ̂ */
/* 荞݂g^Cv̏͌񂵂ɂ */

/* COM2̊荞 */
void inthandler23(int *esp)
{
	return;
}

/* COM1̊荞 */
void inthandler24(int *esp)
{
	return;
}
