/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.dialog;

import com.evernote.edam.error.EDAMNotFoundException;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.edam.type.Notebook;
import com.evernote.edam.type.SharedNotebook;
import com.evernote.thrift.TException;
import com.trolltech.qt.QtEnumerator;
import com.trolltech.qt.core.QModelIndex;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QAbstractItemView;
import com.trolltech.qt.gui.QApplication;
import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QFontMetrics;
import com.trolltech.qt.gui.QHBoxLayout;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QPushButton;
import com.trolltech.qt.gui.QTableWidget;
import com.trolltech.qt.gui.QTableWidgetItem;
import com.trolltech.qt.gui.QVBoxLayout;
import com.trolltech.qt.gui.QWidget;
import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.threads.SyncRunner;
import java.util.ArrayList;
import java.util.List;

public class ShareNotebook
extends QDialog {
    private final QPushButton okButton;
    private final QPushButton addButton;
    private final QPushButton deleteButton;
    private boolean okClicked;
    public final QTableWidget table;
    private final List<SharedNotebook> notebooks;
    private final DatabaseConnection conn;
    private final Notebook notebook;
    private final SyncRunner syncRunner;
    private final String iconPath = new String("classpath:cx/fbn/nevernote/icons/");

    public ShareNotebook(String guid, DatabaseConnection c, Notebook n, SyncRunner s) {
        this.setWindowIcon(new QIcon(String.valueOf(this.iconPath) + "globe.png"));
        this.okClicked = false;
        this.conn = c;
        this.syncRunner = s;
        this.notebook = n;
        this.notebooks = this.conn.getSharedNotebookTable().getForNotebook(n.getGuid());
        this.okButton = new QPushButton();
        this.okButton.setText(this.tr("OK"));
        this.okButton.pressed.connect((Object)this, "onClicked()");
        QHBoxLayout horizontalLayout = new QHBoxLayout();
        QHBoxLayout buttonLayout = new QHBoxLayout();
        buttonLayout.addStretch(1);
        buttonLayout.addWidget((QWidget)this.okButton);
        this.setWindowTitle(String.valueOf(this.tr("Share Notebook \"")) + this.notebook.getName() + this.tr("\" With Others"));
        this.table = new QTableWidget(this.notebooks.size(), 3);
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(this.tr("Email"));
        headers.add(this.tr("Access"));
        headers.add(this.tr("Login Required"));
        this.table.setHorizontalHeaderLabels(headers);
        this.table.verticalHeader().setVisible(false);
        this.table.setAlternatingRowColors(true);
        this.table.setSelectionBehavior(QAbstractItemView.SelectionBehavior.SelectRows);
        this.table.setSelectionMode(QAbstractItemView.SelectionMode.SingleSelection);
        this.table.itemSelectionChanged.connect((Object)this, "tableSelection()");
        horizontalLayout.addWidget((QWidget)this.table);
        this.addButton = new QPushButton();
        this.addButton.setText(this.tr("Add"));
        this.addButton.clicked.connect((Object)this, "addPressed()");
        this.deleteButton = new QPushButton();
        this.deleteButton.setText(this.tr("Delete"));
        this.deleteButton.setEnabled(false);
        this.deleteButton.clicked.connect((Object)this, "deletePressed()");
        QVBoxLayout editLayout = new QVBoxLayout();
        editLayout.addWidget((QWidget)this.addButton);
        editLayout.addWidget((QWidget)this.deleteButton);
        QHBoxLayout listLayout = new QHBoxLayout();
        listLayout.addLayout((QLayout)horizontalLayout);
        listLayout.addLayout((QLayout)editLayout);
        QVBoxLayout mainLayout = new QVBoxLayout();
        if (this.syncRunner.authToken == null) {
            QLabel msg = new QLabel(this.tr("You must be connected to make changes."));
            mainLayout.addWidget((QWidget)msg);
        }
        mainLayout.addLayout((QLayout)listLayout);
        mainLayout.addSpacing(1);
        mainLayout.addLayout((QLayout)buttonLayout);
        this.setLayout((QLayout)mainLayout);
        this.table.setColumnWidth(0, 160);
        this.resize(500, 200);
        this.load();
        if (this.syncRunner.authToken == null) {
            this.addButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        }
    }

    private void onClicked() {
        this.okClicked = true;
        this.close();
    }

    public boolean okClicked() {
        return this.okClicked;
    }

    private void itemSelected() {
        this.okButton.setEnabled(true);
    }

    private void load() {
        int i = 0;
        while (i < this.notebooks.size()) {
            this.addRow(i, this.notebooks.get(i).getEmail(), this.notebooks.get(i).isNotebookModifiable(), this.notebooks.get(i).isRequireLogin());
            ++i;
        }
    }

    private void addRow(int row, String email, boolean mod, boolean login) {
        QFontMetrics f = QApplication.fontMetrics();
        int fontHeight = f.height();
        QTableWidgetItem emailWidget = new QTableWidgetItem();
        emailWidget.setText(email);
        this.table.setItem(row, 0, emailWidget);
        this.table.setRowHeight(row, fontHeight);
        emailWidget.setToolTip(email);
        Qt.ItemFlags flags = emailWidget.flags();
        flags.clear((QtEnumerator[])new Qt.ItemFlag[]{Qt.ItemFlag.ItemIsEditable});
        emailWidget.setFlags(flags);
        QTableWidgetItem accessWidget = new QTableWidgetItem();
        if (mod) {
            accessWidget.setText(this.tr("Modify"));
        } else {
            accessWidget.setText(this.tr("Read Only"));
        }
        this.table.setItem(row, 1, accessWidget);
        accessWidget.setFlags(flags);
        QTableWidgetItem loginWidget = new QTableWidgetItem();
        if (login) {
            loginWidget.setText(this.tr("True"));
        } else {
            loginWidget.setText(this.tr("False"));
        }
        this.table.setItem(row, 2, loginWidget);
        loginWidget.setFlags(flags);
    }

    private void tableSelection() {
        if (this.syncRunner.authToken != null) {
            this.deleteButton.setEnabled(true);
        }
    }

    private void addPressed() {
    }

    private void deletePressed() {
        QModelIndex index = this.table.currentIndex();
        int row = index.row();
        QTableWidgetItem dirWidget = this.table.item(row, 0);
        String value = dirWidget.text();
        List<SharedNotebook> notebooks = this.conn.getSharedNotebookTable().getForNotebook(this.notebook.getGuid());
        ArrayList<Long> ids = new ArrayList<Long>();
        int i = 0;
        while (i < notebooks.size()) {
            if (notebooks.get(i).getEmail().equalsIgnoreCase(value)) {
                ids.add(notebooks.get(i).getId());
            }
            ++i;
        }
        if (ids.size() > 0) {
            try {
                this.syncRunner.localNoteStore.expungeSharedNotebooks(this.syncRunner.authToken, ids);
            }
            catch (EDAMUserException e) {
                e.printStackTrace();
            }
            catch (EDAMNotFoundException e) {
                e.printStackTrace();
            }
            catch (EDAMSystemException e) {
                e.printStackTrace();
            }
            catch (TException e) {
                e.printStackTrace();
            }
            i = 0;
            while (i < ids.size()) {
                this.conn.getSharedNotebookTable().expungeNotebook((Long)ids.get(i), false);
                ++i;
            }
        }
        this.table.clear();
        this.load();
        if (this.table.rowCount() == 0) {
            this.deleteButton.setEnabled(false);
        }
    }
}

