/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.dialog;

import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QGridLayout;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QPushButton;
import com.trolltech.qt.gui.QTextEdit;
import com.trolltech.qt.gui.QWidget;

public class InsertLatexImage
extends QDialog {
    private boolean okPressed = false;
    private final QTextEdit url;
    private final QPushButton ok;
    private String latexText;
    private final String iconPath = new String("classpath:cx/fbn/nevernote/icons/");

    public InsertLatexImage() {
        this.setWindowTitle(this.tr("Insert LaTeX Formula"));
        this.setWindowIcon(new QIcon(String.valueOf(this.iconPath) + "link.png"));
        QGridLayout grid = new QGridLayout();
        QGridLayout input = new QGridLayout();
        QGridLayout button = new QGridLayout();
        this.setLayout((QLayout)grid);
        this.url = new QTextEdit("");
        input.addWidget((QWidget)new QLabel(this.tr("Formula")), 1, 1);
        input.addWidget((QWidget)this.url, 2, 1);
        input.setContentsMargins(10, 10, -10, -10);
        grid.addLayout((QLayout)input, 1, 1);
        this.ok = new QPushButton(this.tr("OK"));
        this.ok.clicked.connect((Object)this, "accept()");
        this.ok.setEnabled(false);
        QPushButton cancel = new QPushButton(this.tr("Cancel"));
        cancel.clicked.connect((Object)this, "reject()");
        button.addWidget((QWidget)this.ok, 1, 1);
        button.addWidget((QWidget)cancel, 1, 2);
        grid.addLayout((QLayout)button, 3, 1);
        this.url.textChanged.connect((Object)this, "validateInput()");
        this.setAttribute(Qt.WidgetAttribute.WA_DeleteOnClose);
    }

    public void setFormula(String x) {
        this.url.setText(x);
    }

    public String getFormula() {
        return this.latexText;
    }

    public void setUrl(String u) {
        this.url.setText(u);
    }

    public boolean okPressed() {
        return this.okPressed;
    }

    private void validateInput() {
        this.ok.setEnabled(true);
        if (this.url.toPlainText().trim().equals("")) {
            this.ok.setEnabled(false);
        }
    }

    public void accept() {
        if (this.ok.isEnabled()) {
            this.okPressed = true;
            this.latexText = this.url.toPlainText();
            super.accept();
        }
    }

    public void reject() {
        this.okPressed = false;
        super.reject();
    }
}

