/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.threads;

import com.evernote.edam.type.Resource;
import com.trolltech.qt.core.QMutex;
import com.trolltech.qt.core.QObject;
import cx.fbn.nevernote.Global;
import cx.fbn.nevernote.evernote.EnmlConverter;
import cx.fbn.nevernote.signals.NoteSignal;
import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import cx.fbn.nevernote.utilities.Pair;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;

public class SaveRunner
extends QObject
implements Runnable {
    private final ApplicationLogger logger;
    public volatile boolean keepRunning;
    public QMutex threadLock;
    private final DatabaseConnection conn;
    private boolean idle;
    public NoteSignal noteSignals;
    private volatile LinkedBlockingQueue<Pair<String, String>> workQueue = new LinkedBlockingQueue();

    public SaveRunner(String logname, String u, String i, String r, String b, String uid, String pswd, String cpswd) {
        this.logger = new ApplicationLogger(logname);
        this.conn = new DatabaseConnection(this.logger, u, i, r, b, uid, pswd, cpswd, 0);
        this.threadLock = new QMutex();
        this.keepRunning = true;
        this.noteSignals = new NoteSignal();
    }

    public SaveRunner(ApplicationLogger l, DatabaseConnection c) {
        this.logger = l;
        this.conn = c;
        this.keepRunning = true;
        this.noteSignals = new NoteSignal();
    }

    @Override
    public void run() {
        this.thread().setPriority(1);
        boolean keepRunning = true;
        while (keepRunning) {
            try {
                this.idle = true;
                Pair<String, String> content = this.workQueue.take();
                if (!content.getFirst().equalsIgnoreCase("stop")) {
                    this.idle = false;
                    GregorianCalendar now = new GregorianCalendar();
                    long prev = now.getTimeInMillis();
                    prev += 200L;
                    while (prev > now.getTimeInMillis()) {
                        now = new GregorianCalendar();
                    }
                } else {
                    return;
                }
                this.updateNoteContent(content.getFirst(), content.getSecond());
                this.threadLock.unlock();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.conn.dbShutdown();
    }

    public synchronized void addWork(String guid, String content) {
        while (this.workQueue.size() > 0) {
        }
        Pair<String, String> pair = new Pair<String, String>(guid, content);
        this.workQueue.offer(pair);
    }

    public synchronized void release(String guid, String content) {
        Pair<String, String> pair = new Pair<String, String>(guid, content);
        this.workQueue.add(pair);
    }

    public synchronized int getWorkQueueSize() {
        return this.workQueue.size();
    }

    public void setKeepRunning(boolean b) {
        this.keepRunning = b;
    }

    public boolean keepRunning() {
        return this.keepRunning;
    }

    public boolean isIdle() {
        return this.idle;
    }

    public void updateNoteContent(String guid, String content) {
        this.logger.log(this.logger.HIGH, "Entering ListManager.updateNoteContent");
        EnmlConverter enml = new EnmlConverter(this.logger);
        String newContent = enml.convert(guid, content);
        String fixedContent = enml.fixEnXMLCrap(newContent);
        if (fixedContent != null) {
            this.conn.getNoteTable().updateNoteContent(guid, fixedContent);
            this.logger.log(this.logger.EXTREME, "Saving new note resources");
            List<Resource> oldResources = this.conn.getNoteTable().noteResourceTable.getNoteResources(guid, false);
            List<String> newResources = enml.getResources();
            this.removeObsoleteResources(oldResources, newResources);
        } else {
            this.noteSignals.noteSaveRunnerError.emit((Object)guid, null);
        }
        this.logger.log(this.logger.HIGH, "Leaving ListManager.updateNoteContent");
    }

    private void removeObsoleteResources(List<Resource> oldResources, List<String> newResources) {
        int i;
        if (oldResources == null || oldResources.size() == 0) {
            return;
        }
        if (newResources == null || newResources.size() == 0) {
            i = 0;
            while (i < oldResources.size()) {
                this.conn.getNoteTable().noteResourceTable.expungeNoteResource(oldResources.get(i).getGuid());
                ++i;
            }
        }
        i = 0;
        while (i < oldResources.size()) {
            boolean matchFound = false;
            int j = 0;
            while (j < newResources.size()) {
                if (newResources.get(j).equalsIgnoreCase(oldResources.get(i).getGuid())) {
                    matchFound = true;
                }
                if (Global.resourceMap.get(newResources.get(j)) != null && Global.resourceMap.get(newResources.get(j)).equalsIgnoreCase(oldResources.get(i).getGuid())) {
                    matchFound = true;
                }
                if (matchFound) {
                    j = newResources.size();
                }
                ++j;
            }
            if (!matchFound) {
                this.conn.getNoteTable().noteResourceTable.expungeNoteResource(oldResources.get(i).getGuid());
            }
            ++i;
        }
    }
}

