/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.gui;

import com.trolltech.qt.QSignalEmitter;
import com.trolltech.qt.core.QUrl;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QAction;
import com.trolltech.qt.gui.QCloseEvent;
import com.trolltech.qt.gui.QDesktopServices;
import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QMdiSubWindow;
import com.trolltech.qt.gui.QPrintDialog;
import com.trolltech.qt.gui.QPrinter;
import cx.fbn.nevernote.Global;
import cx.fbn.nevernote.dialog.FindDialog;
import cx.fbn.nevernote.gui.BrowserWindow;
import cx.fbn.nevernote.gui.ExternalBrowserMenuBar;
import cx.fbn.nevernote.neighbornote.ClipBoardObserver;
import cx.fbn.nevernote.sql.DatabaseConnection;
import java.awt.Desktop;
import java.util.List;

public class ExternalBrowse
extends QMdiSubWindow {
    private final DatabaseConnection conn;
    private final BrowserWindow browser;
    public QSignalEmitter.Signal4<String, String, Boolean, BrowserWindow> contentsChanged;
    public QSignalEmitter.Signal1<String> windowClosing;
    boolean noteDirty;
    String saveTitle;
    private final FindDialog find;
    ExternalBrowserMenuBar menu;
    private final ClipBoardObserver cbObserver;

    public ExternalBrowse(DatabaseConnection c, ClipBoardObserver cbObserver) {
        this.setAttribute(Qt.WidgetAttribute.WA_QuitOnClose, false);
        this.setWindowTitle(this.tr("NeighborNote"));
        this.conn = c;
        this.cbObserver = cbObserver;
        this.contentsChanged = new QSignalEmitter.Signal4((QSignalEmitter)this);
        this.windowClosing = new QSignalEmitter.Signal1((QSignalEmitter)this);
        this.browser = new BrowserWindow(this.conn, this.cbObserver);
        this.menu = new ExternalBrowserMenuBar(this);
        int i = 0;
        while (i < this.menu.actions().size()) {
            this.addAction((QAction)this.menu.actions().get(i));
            ++i;
        }
        this.setWidget(this.browser);
        this.noteDirty = false;
        this.browser.titleLabel.textChanged.connect((Object)this, "titleChanged(String)");
        this.browser.getBrowser().page().contentsChanged.connect((Object)this, "contentChanged()");
        this.find = new FindDialog();
        this.find.getOkButton().clicked.connect((Object)this, "doFindText()");
    }

    private void contentChanged() {
        this.noteDirty = true;
        this.contentsChanged.emit((Object)this.getBrowserWindow().getNote().getGuid(), (Object)this.getBrowserWindow().getContent(), (Object)false, (Object)this.getBrowserWindow());
    }

    public void closeEvent(QCloseEvent event) {
        if (this.noteDirty) {
            this.contentsChanged.emit((Object)this.getBrowserWindow().getNote().getGuid(), (Object)this.getBrowserWindow().getContent(), (Object)true, (Object)this.getBrowserWindow());
        }
        this.windowClosing.emit((Object)this.getBrowserWindow().getNote().getGuid());
    }

    public BrowserWindow getBrowserWindow() {
        return this.browser;
    }

    private void titleChanged(String value) {
        this.setWindowTitle(String.valueOf(this.tr("NeighborNote - ")) + value);
    }

    private void updateTitle(String guid, String title) {
        if (guid.equals(this.getBrowserWindow().getNote().getGuid()) && (this.saveTitle != null && !title.equals(this.saveTitle) || this.saveTitle == null)) {
            this.saveTitle = title;
            this.getBrowserWindow().loadingData(true);
            this.getBrowserWindow().setTitle(title);
            this.getBrowserWindow().getNote().setTitle(title);
            this.getBrowserWindow().loadingData(false);
        }
    }

    private void updateNotebook(String guid, String notebook) {
        if (guid.equals(this.getBrowserWindow().getNote().getGuid())) {
            this.getBrowserWindow().loadingData(true);
            this.getBrowserWindow().setNotebook(notebook);
            this.getBrowserWindow().loadingData(false);
        }
    }

    private void updateTags(String guid, List<String> tags) {
        if (guid.equals(this.getBrowserWindow().getNote().getGuid())) {
            StringBuffer tagLine = new StringBuffer(100);
            int i = 0;
            while (i < tags.size()) {
                if (i > 0) {
                    tagLine.append(String.valueOf(Global.tagDelimeter) + " ");
                }
                tagLine.append(tags.get(i));
                ++i;
            }
            this.getBrowserWindow().loadingData(true);
            this.getBrowserWindow().getTagLine().setText(tagLine.toString());
            this.getBrowserWindow().loadingData(false);
        }
    }

    private void findText() {
        this.find.show();
        this.find.setFocusOnTextField();
    }

    private void doFindText() {
        this.browser.getBrowser().page().findText(this.find.getText(), this.find.getFlags());
        this.find.setFocus();
    }

    private void printNote() {
        QPrintDialog dialog = new QPrintDialog();
        if (dialog.exec() == QDialog.DialogCode.Accepted.value()) {
            QPrinter printer = dialog.printer();
            this.browser.getBrowser().print(printer);
        }
    }

    private void emailNote() {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            String text2 = this.browser.getContentsToEmail();
            QUrl url = new QUrl("mailto:");
            url.addQueryItem("subject", this.browser.getTitle());
            url.addQueryItem("body", text2);
            QDesktopServices.openUrl((QUrl)url);
        }
    }
}

