/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.utilities;

import cx.fbn.nevernote.Global;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class ApplicationLogger {
    public final int LOW = 1;
    public final int MEDIUM = 2;
    public final int HIGH = 3;
    public final int EXTREME = 4;
    FileOutputStream fileStream;
    PrintStream stdoutPrintStream;

    public ApplicationLogger(String name) {
        try {
            this.fileStream = new FileOutputStream(Global.getFileManager().getLogsDirFile(name));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.stdoutPrintStream = new PrintStream(this.fileStream);
    }

    public synchronized void log(int messageLevel, String s) {
        if (messageLevel <= Global.messageLevel) {
            String DATE_FORMAT_NOW = "yyyy-MM-dd HH:mm:ss.SS ";
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_NOW);
            this.stdoutPrintStream.println(String.valueOf(sdf.format(cal.getTime())) + s);
        }
    }

    public void log(int level, StackTraceElement[] e) {
        if (level >= Global.messageLevel) {
            StackTraceElement element;
            String DATE_FORMAT_NOW = "yyyy-MM-dd HH:mm:ss.SS ";
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_NOW);
            System.out.println(e);
            System.out.println("*** Stack Trace Requested ***");
            System.out.println(sdf.format(cal.getTime()));
            StackTraceElement[] stackTraceElementArray = e;
            int n = e.length;
            int n2 = 0;
            while (n2 < n) {
                element = stackTraceElementArray[n2];
                System.out.println("Line Number: " + new Integer(element.getLineNumber()));
                System.out.println("Class Name: " + element.getClassName());
                System.out.println("Method Name:" + element.getMethodName());
                System.out.println("File Name:" + element.getFileName());
                System.out.println("-Next Element-");
                ++n2;
            }
            System.out.println("**************************");
            System.setOut(this.stdoutPrintStream);
            System.out.print(e);
            System.out.print("*** Stack Trace Requested ***");
            System.out.print(sdf.format(cal.getTime()));
            stackTraceElementArray = e;
            n = e.length;
            n2 = 0;
            while (n2 < n) {
                element = stackTraceElementArray[n2];
                System.out.print("Line Number: " + new Integer(element.getLineNumber()));
                System.out.print("Class Name: " + element.getClassName());
                System.out.print("Method Name:" + element.getMethodName());
                System.out.print("File Name:" + element.getFileName());
                System.out.print("-Next Element-");
                ++n2;
            }
            System.out.print("**************************");
        }
    }
}

