/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.dialog;

import com.trolltech.qt.QSignalEmitter;
import com.trolltech.qt.core.QPoint;
import com.trolltech.qt.core.QRect;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QApplication;
import com.trolltech.qt.gui.QColor;
import com.trolltech.qt.gui.QDesktopWidget;
import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QGridLayout;
import com.trolltech.qt.gui.QImage;
import com.trolltech.qt.gui.QKeyEvent;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QMouseEvent;
import com.trolltech.qt.gui.QPaintEvent;
import com.trolltech.qt.gui.QPainter;
import com.trolltech.qt.gui.QPalette;
import com.trolltech.qt.gui.QPixmap;
import com.trolltech.qt.gui.QWheelEvent;
import com.trolltech.qt.gui.QWidget;
import java.util.List;

public class ThumbnailViewer
extends QDialog {
    private String thumbnail;
    private final QLabel picture;
    QGridLayout grid = new QGridLayout();
    public QSignalEmitter.Signal0 upArrow;
    public QSignalEmitter.Signal0 downArrow;
    public QSignalEmitter.Signal0 leftArrow;
    public QSignalEmitter.Signal0 rightArrow;
    private QImage image;
    private List<String> guids;

    public ThumbnailViewer() {
        this.setVisible(false);
        this.leftArrow = new QSignalEmitter.Signal0((QSignalEmitter)this);
        this.rightArrow = new QSignalEmitter.Signal0((QSignalEmitter)this);
        this.upArrow = new QSignalEmitter.Signal0((QSignalEmitter)this);
        this.downArrow = new QSignalEmitter.Signal0((QSignalEmitter)this);
        this.setAutoFillBackground(true);
        QPalette palette = new QPalette(this.palette());
        palette.setColor(QPalette.ColorRole.Base, QColor.black);
        this.setPalette(palette);
        this.grid = new QGridLayout();
        this.setLayout((QLayout)this.grid);
        this.picture = new QLabel();
        this.setWindowModality(Qt.WindowModality.ApplicationModal);
        this.setWindowFlags(new Qt.WindowType[]{Qt.WindowType.FramelessWindowHint});
        this.setAttribute(Qt.WidgetAttribute.WA_TranslucentBackground);
    }

    public void setThumbnail(String thumb) {
        this.thumbnail = thumb;
        this.image = new QImage(this.thumbnail);
        this.picture.setPixmap(QPixmap.fromImage((QImage)this.image));
    }

    public void setThumbnail(QImage i) {
        this.image = i;
        this.picture.setPixmap(QPixmap.fromImage((QImage)this.image));
    }

    public void keyPressEvent(QKeyEvent e) {
        if (e.key() == Qt.Key.Key_Up.value() || e.key() == Qt.Key.Key_Right.value()) {
            this.upArrow.emit();
        }
        if (e.key() == Qt.Key.Key_Down.value() || e.key() == Qt.Key.Key_Left.value()) {
            this.downArrow.emit();
        }
        super.keyPressEvent(e);
    }

    public void mousePressEvent(QMouseEvent e) {
        if (e.button() == Qt.MouseButton.LeftButton) {
            this.close();
        }
    }

    public void wheelEvent(QWheelEvent e) {
        int numDegrees = e.delta() / 8;
        int numSteps = numDegrees / 15;
        if (e.orientation().equals((Object)Qt.Orientation.Vertical)) {
            int i;
            if (numSteps > 0) {
                i = 0;
                while (i < numSteps) {
                    this.upArrow.emit();
                    this.repaint();
                    ++i;
                }
            }
            if (numSteps < 0) {
                i = numSteps;
                while (i < 0) {
                    this.downArrow.emit();
                    this.repaint();
                    ++i;
                }
            }
        }
    }

    public void paintEvent(QPaintEvent e) {
        QDesktopWidget desktop = QApplication.desktop();
        int screen = desktop.screenNumber();
        this.setMaximumSize(desktop.size());
        this.setMinimumSize(desktop.size());
        this.resize(desktop.size());
        QPainter painter = new QPainter((QWidget)this);
        painter.fillRect(desktop.screenGeometry(screen), QColor.black);
        QRect availGeo = desktop.availableGeometry(screen);
        int x1 = availGeo.width() / 2 - this.image.size().width() / 2;
        int y1 = availGeo.height() / 2 - this.image.size().height() / 2;
        painter.drawImage(new QPoint(x1, y1), this.image);
    }

    public List<String> getGuids() {
        return this.guids;
    }

    public void setGuids(List<String> g) {
        this.guids = g;
    }
}

