/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.gui;

import com.evernote.edam.type.Note;
import com.evernote.edam.type.Notebook;
import com.trolltech.qt.QSignalEmitter;
import com.trolltech.qt.core.QByteArray;
import com.trolltech.qt.core.QMimeData;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QAbstractItemView;
import com.trolltech.qt.gui.QAction;
import com.trolltech.qt.gui.QBrush;
import com.trolltech.qt.gui.QColor;
import com.trolltech.qt.gui.QContextMenuEvent;
import com.trolltech.qt.gui.QDragEnterEvent;
import com.trolltech.qt.gui.QDragMoveEvent;
import com.trolltech.qt.gui.QHeaderView;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QMenu;
import com.trolltech.qt.gui.QMouseEvent;
import com.trolltech.qt.gui.QTreeWidget;
import com.trolltech.qt.gui.QTreeWidgetItem;
import com.trolltech.qt.gui.QWidget;
import cx.fbn.nevernote.Global;
import cx.fbn.nevernote.filters.NotebookCounter;
import cx.fbn.nevernote.gui.NTreeWidgetItem;
import cx.fbn.nevernote.signals.NoteSignal;
import cx.fbn.nevernote.sql.DatabaseConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class NotebookTreeWidget
extends QTreeWidget {
    private QAction deleteAction;
    private QAction addAction;
    private QAction editAction;
    private QAction iconAction;
    private QAction stackAction;
    private QAction publishAction;
    private QAction shareAction;
    public NoteSignal noteSignal = new NoteSignal();
    public QSignalEmitter.Signal0 selectionSignal;
    private String selectedNotebook;
    private HashMap<String, QIcon> icons;
    private final DatabaseConnection db;
    private final HashMap<String, QTreeWidgetItem> stacks;
    private boolean rightButtonClicked;

    public void setAddAction(QAction a) {
        this.addAction = a;
    }

    public void setPublishAction(QAction p) {
        this.publishAction = p;
    }

    public void setShareAction(QAction s) {
        this.shareAction = s;
    }

    public void setDeleteAction(QAction d) {
        this.deleteAction = d;
    }

    public void setEditAction(QAction e) {
        this.editAction = e;
    }

    public void setStackAction(QAction e) {
        this.stackAction = e;
    }

    public void setIconAction(QAction e) {
        this.iconAction = e;
    }

    public NotebookTreeWidget(DatabaseConnection db) {
        this.db = db;
        ArrayList<String> labels = new ArrayList<String>();
        labels.add(this.tr("Notebooks"));
        labels.add("");
        this.setAcceptDrops(true);
        this.setDragEnabled(true);
        this.setColumnCount(2);
        this.header().setResizeMode(0, QHeaderView.ResizeMode.ResizeToContents);
        this.header().setResizeMode(1, QHeaderView.ResizeMode.Stretch);
        this.header().setMovable(false);
        this.header().setStyleSheet("QHeaderView::section {border: 0.0em;}");
        this.setHeaderLabels(labels);
        this.setDragDropMode(QAbstractItemView.DragDropMode.DragDrop);
        if (Global.mimicEvernoteInterface) {
            this.setSelectionMode(QAbstractItemView.SelectionMode.SingleSelection);
        } else {
            this.setSelectionMode(QAbstractItemView.SelectionMode.ExtendedSelection);
        }
        this.stacks = new HashMap();
        this.selectionSignal = new QSignalEmitter.Signal0((QSignalEmitter)this);
        this.selectedNotebook = "";
        this.rightButtonClicked = false;
        this.itemClicked.connect((Object)this, "itemClicked()");
    }

    public void selectNotebook(QTreeWidgetItem item) {
        QTreeWidgetItem root = this.invisibleRootItem();
        int i = 0;
        while (i < root.childCount()) {
            QTreeWidgetItem child = root.child(i);
            if (child.text(2).equals(item.text(2))) {
                child.setSelected(true);
                return;
            }
            ++i;
        }
    }

    public boolean selectGuid(String guid) {
        QTreeWidgetItem root = this.invisibleRootItem();
        int i = 0;
        while (i < root.childCount()) {
            QTreeWidgetItem child = root.child(i);
            if (child.text(2).equals(guid)) {
                child.setSelected(true);
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setIcons(HashMap<String, QIcon> i) {
        this.icons = i;
    }

    public QIcon findDefaultIcon(String guid, String name, List<String> localBooks, boolean isPublished) {
        String iconPath = new String("classpath:cx/fbn/nevernote/icons/");
        QIcon blueIcon = new QIcon(String.valueOf(iconPath) + "notebook-blue.png");
        QIcon greenIcon = new QIcon(String.valueOf(iconPath) + "notebook-green.png");
        QIcon redIcon = new QIcon(String.valueOf(iconPath) + "notebook-red.png");
        QIcon yellowIcon = new QIcon(String.valueOf(iconPath) + "notebook-yellow.png");
        QIcon orangeIcon = new QIcon(String.valueOf(iconPath) + "notebook-orange.png");
        if (localBooks.contains(guid) && (name.equalsIgnoreCase("Conflicting Changes") || name.equalsIgnoreCase("Conflicting Changes (Local)"))) {
            return redIcon;
        }
        if (localBooks.contains(guid)) {
            return yellowIcon;
        }
        if (isPublished) {
            return blueIcon;
        }
        if (this.db.getNotebookTable().isLinked(guid)) {
            return orangeIcon;
        }
        return greenIcon;
    }

    public void load(List<Notebook> books, List<String> localBooks) {
        NTreeWidgetItem child;
        QTreeWidgetItem root = this.invisibleRootItem();
        ArrayList<String> expandedStacks = new ArrayList<String>();
        int i = 0;
        while (i < root.childCount()) {
            if (root.child(i).isExpanded()) {
                expandedStacks.add(root.child(i).text(0));
            }
            ++i;
        }
        this.clear();
        this.stacks.clear();
        if (books == null) {
            return;
        }
        Qt.Alignment ra = new Qt.Alignment(new Qt.AlignmentFlag[]{Qt.AlignmentFlag.AlignRight});
        int i2 = 0;
        while (i2 < books.size()) {
            Notebook book = books.get(i2);
            child = new NTreeWidgetItem();
            child.setChildIndicatorPolicy(QTreeWidgetItem.ChildIndicatorPolicy.DontShowIndicatorWhenChildless);
            child.setText(0, book.getName());
            if (this.icons != null && !this.icons.containsKey(book.getGuid())) {
                QIcon icon = this.findDefaultIcon(book.getGuid(), book.getName(), localBooks, book.isPublished());
                child.setIcon(0, icon);
            } else {
                child.setIcon(0, this.icons.get(book.getGuid()));
            }
            child.setTextAlignment(1, ra.value());
            child.setText(2, book.getGuid());
            if (book.getStack() == null || book.getStack().equalsIgnoreCase("")) {
                this.addTopLevelItem(child);
            } else {
                QTreeWidgetItem parent;
                String stackName = book.getStack();
                if (!this.stacks.containsKey(stackName)) {
                    parent = this.createStackIcon(stackName, ra);
                    this.addTopLevelItem(parent);
                    this.stacks.put(stackName, parent);
                } else {
                    parent = this.stacks.get(stackName);
                }
                parent.addChild((QTreeWidgetItem)child);
            }
            ++i2;
        }
        this.sortItems(0, Qt.SortOrder.AscendingOrder);
        if (Global.mimicEvernoteInterface) {
            String iconPath = new String("classpath:cx/fbn/nevernote/icons/");
            QIcon allIcon = this.db.getSystemIconTable().getIcon("All Notebooks", "ALLNOTEBOOK");
            if (allIcon == null) {
                allIcon = new QIcon(String.valueOf(iconPath) + "notebook-green.png");
            }
            child = new NTreeWidgetItem();
            child.setIcon(0, allIcon);
            child.setText(0, this.tr("All Notebooks"));
            child.setText(2, "");
            child.setTextAlignment(1, ra.value());
            this.insertTopLevelItem(0, child);
        }
        this.resizeColumnToContents(0);
        this.resizeColumnToContents(1);
        root = this.invisibleRootItem();
        i = 0;
        while (i < root.childCount()) {
            int j = 0;
            while (j < expandedStacks.size()) {
                if (root.child(i).text(0).equalsIgnoreCase((String)expandedStacks.get(j))) {
                    this.expandItem(root.child(i));
                    j = expandedStacks.size();
                }
                ++j;
            }
            ++i;
        }
    }

    public void updateCounts(List<Notebook> books, List<NotebookCounter> counts) {
        QTreeWidgetItem child;
        QTreeWidgetItem root = this.invisibleRootItem();
        QBrush blue = new QBrush();
        QBrush black = new QBrush();
        black.setColor(QColor.black);
        if (Global.tagBehavior().equalsIgnoreCase("ColorActive") && !Global.mimicEvernoteInterface) {
            blue.setColor(QColor.blue);
        } else {
            blue.setColor(QColor.black);
        }
        int total = 0;
        int size = books.size();
        if (Global.mimicEvernoteInterface) {
            ++size;
        }
        int i = 0;
        while (i < size) {
            child = root.child(i);
            if (child != null && child.childCount() > 0) {
                int count = child.childCount();
                QTreeWidgetItem parent = child;
                int localTotal = 0;
                int j = 0;
                while (j < count) {
                    child = parent.child(j);
                    int childCount = this.updateCounts(child, books, counts, blue, black);
                    total += childCount;
                    localTotal += childCount;
                    ++j;
                }
                parent.setText(1, new Integer(localTotal).toString());
            } else {
                total += this.updateCounts(child, books, counts, blue, black);
            }
            ++i;
        }
        i = 0;
        while (i < size) {
            String guid;
            child = root.child(i);
            if (child != null && (guid = child.text(2)).equals("") && Global.mimicEvernoteInterface) {
                child.setText(1, new Integer(total).toString());
            }
            ++i;
        }
    }

    private int updateCounts(QTreeWidgetItem child, List<Notebook> books, List<NotebookCounter> counts, QBrush blue, QBrush black) {
        int total = 0;
        if (child != null) {
            String guid = child.text(2);
            child.setText(1, "0");
            child.setForeground(0, black);
            child.setForeground(1, black);
            int j = 0;
            while (j < counts.size()) {
                if (counts.get(j).getGuid().equals(guid)) {
                    child.setText(1, new Integer(counts.get(j).getCount()).toString());
                    total = counts.get(j).getCount();
                    if (counts.get(j).getCount() > 0) {
                        child.setForeground(0, blue);
                        child.setForeground(1, blue);
                    }
                }
                ++j;
            }
        }
        return total;
    }

    public List<String> getNotebookGuids() {
        ArrayList<String> names = new ArrayList<String>();
        QTreeWidgetItem root = this.invisibleRootItem();
        int i = 0;
        while (i < root.childCount()) {
            QTreeWidgetItem child = root.child(i);
            String text = child.text(2);
            names.add(text);
            ++i;
        }
        return names;
    }

    public void contextMenuEvent(QContextMenuEvent event) {
        QMenu menu = new QMenu((QWidget)this);
        menu.addAction(this.addAction);
        menu.addAction(this.editAction);
        menu.addAction(this.deleteAction);
        menu.addAction(this.stackAction);
        menu.addSeparator();
        menu.addAction(this.publishAction);
        menu.addAction(this.shareAction);
        menu.addSeparator();
        menu.addAction(this.iconAction);
        menu.exec(event.globalPos());
    }

    public void dragEnterEvent(QDragEnterEvent event) {
        if (event.mimeData().hasFormat("application/x-nevernote-note")) {
            event.accept();
            return;
        }
        if (event.source() == this) {
            event.mimeData().setData("application/x-nevernote-notebook", new QByteArray(this.currentItem().text(2)));
            List selected = this.selectedItems();
            int i = 0;
            while (i < selected.size()) {
                if (((QTreeWidgetItem)selected.get(i)).text(2).equalsIgnoreCase("STACK") || ((QTreeWidgetItem)selected.get(i)).text(2).equals("")) {
                    event.ignore();
                    return;
                }
                ++i;
            }
            event.accept();
            return;
        }
        event.ignore();
    }

    protected void dragMoveEvent(QDragMoveEvent event) {
        QTreeWidgetItem treeItem = this.itemAt(event.pos().x(), event.pos().y());
        if (event.mimeData().hasFormat("application/x-nevernote-note")) {
            if (event.answerRect().intersects(this.childrenRect())) {
                event.acceptProposedAction();
            }
            return;
        }
    }

    public boolean dropMimeData(QTreeWidgetItem parent, int index, QMimeData data, Qt.DropAction action) {
        if (data.hasFormat("application/x-nevernote-notebook")) {
            return false;
        }
        if (data.hasFormat("application/x-nevernote-notebook")) {
            QTreeWidgetItem stackItem;
            String stackName;
            QByteArray d = data.data("application/x-nevernote-notebook");
            String current = d.toString();
            if (parent == null) {
                this.db.getNotebookTable().clearStack(current);
                return true;
            }
            if (parent.text(2).equals("")) {
                return false;
            }
            List currentItems = this.selectedItems();
            if (!parent.text(2).equalsIgnoreCase("STACK")) {
                if (parent.parent() != null) {
                    stackName = parent.parent().text(0);
                    stackItem = parent.parent();
                } else {
                    currentItems.add(parent);
                    stackName = "New Stack";
                    int i = 1;
                    while (i < 101) {
                        if (!this.stacks.containsKey(stackName)) break;
                        stackName = "New Stack(" + new Integer(i).toString() + ")";
                        ++i;
                    }
                    this.db.getNotebookTable().setStack(parent.text(2), stackName);
                    Qt.Alignment ra = new Qt.Alignment(new Qt.AlignmentFlag[]{Qt.AlignmentFlag.AlignRight});
                    stackItem = this.createStackIcon(stackName, ra);
                    this.addTopLevelItem(stackItem);
                }
            } else {
                stackName = parent.text(0);
                stackItem = parent;
            }
            ArrayList<QTreeWidgetItem> newItems = new ArrayList<QTreeWidgetItem>();
            int i = 0;
            while (i < currentItems.size()) {
                newItems.add(this.copyTreeItem((QTreeWidgetItem)currentItems.get(i)));
                ((QTreeWidgetItem)currentItems.get(i)).setHidden(true);
                ++i;
            }
            this.db.getNotebookTable().setStack(current, stackName);
            stackItem.addChildren(newItems);
            return true;
        }
        if (data.hasFormat("application/x-nevernote-note")) {
            String[] noteGuidArray;
            if (this.db.getNotebookTable().isReadOnly(parent.text(2))) {
                return false;
            }
            QByteArray d = data.data("application/x-nevernote-note");
            String s = d.toString();
            String[] stringArray = noteGuidArray = s.split(" ");
            int n = noteGuidArray.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                Note n3 = this.db.getNoteTable().getNote(element.trim(), false, false, false, false, true);
                if (!(parent.text(2).equalsIgnoreCase("") || parent.text(2).equalsIgnoreCase(this.tr("STACK")) || n3.getNotebookGuid().equalsIgnoreCase(parent.text(2)))) {
                    this.noteSignal.notebookChanged.emit((Object)element.trim(), (Object)parent.text(2));
                    if (this.db.getNotebookTable().isLinked(parent.text(2))) {
                        this.noteSignal.tagsChanged.emit((Object)element.trim(), new ArrayList());
                    }
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    private QTreeWidgetItem createStackIcon(String stackName, Qt.Alignment ra) {
        String iconPath = new String("classpath:cx/fbn/nevernote/icons/");
        QIcon stackIcon = this.db.getSystemIconTable().getIcon(stackName, "STACK");
        if (stackIcon == null) {
            stackIcon = new QIcon(String.valueOf(iconPath) + "books2.png");
        }
        QTreeWidgetItem parent = new QTreeWidgetItem();
        this.stacks.put(stackName, parent);
        parent.setText(0, stackName);
        parent.setIcon(0, stackIcon);
        parent.setText(2, "STACK");
        parent.setTextAlignment(1, ra.value());
        return parent;
    }

    private QTreeWidgetItem copyTreeItem(QTreeWidgetItem source) {
        QTreeWidgetItem target = new QTreeWidgetItem((QTreeWidget)this);
        target.setText(0, source.text(0));
        target.setIcon(0, source.icon(0));
        target.setText(1, source.text(1));
        target.setText(2, source.text(2));
        Qt.Alignment ra = new Qt.Alignment(new Qt.AlignmentFlag[]{Qt.AlignmentFlag.AlignRight});
        target.setTextAlignment(1, ra.value());
        source.setHidden(true);
        return target;
    }

    private void itemClicked() {
        List selectedItem = this.selectedItems();
        if (selectedItem.size() == 1) {
            if (((QTreeWidgetItem)selectedItem.get(0)).text(0).equalsIgnoreCase(this.selectedNotebook) && !Global.mimicEvernoteInterface && !this.rightButtonClicked) {
                this.selectedNotebook = "";
                this.clearSelection();
            } else {
                this.selectedNotebook = ((QTreeWidgetItem)selectedItem.get(0)).text(0);
            }
        }
        this.selectionSignal.emit();
    }

    public void mousePressEvent(QMouseEvent e) {
        this.rightButtonClicked = e.button() == Qt.MouseButton.RightButton;
        super.mousePressEvent(e);
    }
}

