/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.dialog;

import com.evernote.edam.type.Notebook;
import com.trolltech.qt.gui.QComboBox;
import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QFileDialog;
import com.trolltech.qt.gui.QGridLayout;
import com.trolltech.qt.gui.QHBoxLayout;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QPushButton;
import com.trolltech.qt.gui.QVBoxLayout;
import com.trolltech.qt.gui.QWidget;
import cx.fbn.nevernote.sql.WatchFolderRecord;
import java.util.List;

public class WatchFolderAdd
extends QDialog {
    private final QPushButton okButton;
    private final QPushButton cancelButton;
    private boolean okClicked;
    private final List<Notebook> notebooks;
    private final WatchFolderRecord record;
    public final QLabel directory;
    public final QComboBox keep;
    public final QComboBox books;
    private final String iconPath = new String("classpath:cx/fbn/nevernote/icons/");

    public WatchFolderAdd(WatchFolderRecord w, List<Notebook> n) {
        this.setWindowIcon(new QIcon(String.valueOf(this.iconPath) + "folder.png"));
        this.okClicked = false;
        this.notebooks = n;
        this.record = w;
        this.okButton = new QPushButton();
        this.okButton.setText(this.tr("OK"));
        this.okButton.pressed.connect((Object)this, "onClicked()");
        this.cancelButton = new QPushButton();
        this.cancelButton.setText(this.tr("Cancel"));
        this.cancelButton.pressed.connect((Object)this, "onCancel()");
        QPushButton folderButton = new QPushButton();
        folderButton.setText(this.tr("Directory"));
        folderButton.clicked.connect((Object)this, "folderButtonClicked()");
        this.directory = new QLabel();
        if (this.record != null) {
            this.directory.setText(this.record.folder);
        } else {
            this.directory.setText(System.getProperty("user.home"));
        }
        this.keep = new QComboBox();
        this.keep.addItem(this.tr("Keep"), (Object)"Keep");
        this.keep.addItem(this.tr("Delete"), (Object)"Delete");
        if (this.record != null) {
            if (this.record.keep) {
                this.keep.setCurrentIndex(0);
            } else {
                this.keep.setCurrentIndex(1);
            }
        }
        this.books = new QComboBox();
        int i = 0;
        while (i < this.notebooks.size()) {
            this.books.addItem(this.notebooks.get(i).getName());
            if (this.record != null && this.record.notebook.equals(this.notebooks.get(i).getName())) {
                this.books.setCurrentIndex(i);
            }
            ++i;
        }
        QGridLayout grid = new QGridLayout();
        grid.addWidget((QWidget)this.directory, 0, 1);
        grid.addWidget((QWidget)folderButton, 0, 0);
        grid.addWidget((QWidget)new QLabel(this.tr("Notebook")), 1, 0);
        grid.addWidget((QWidget)this.books, 1, 1);
        grid.addWidget((QWidget)new QLabel(this.tr("After Import")), 2, 0);
        grid.addWidget((QWidget)this.keep, 2, 1);
        QHBoxLayout buttonLayout = new QHBoxLayout();
        buttonLayout.addStretch(1);
        buttonLayout.addWidget((QWidget)this.okButton);
        buttonLayout.addWidget((QWidget)this.cancelButton);
        this.setWindowTitle(this.tr("Add Import Folder"));
        QVBoxLayout mainLayout = new QVBoxLayout();
        mainLayout.addLayout((QLayout)grid);
        mainLayout.addSpacing(1);
        mainLayout.addLayout((QLayout)buttonLayout);
        this.setLayout((QLayout)mainLayout);
    }

    private void onClicked() {
        this.okClicked = true;
        this.close();
    }

    private void onCancel() {
        this.okClicked = false;
        this.close();
    }

    public boolean okClicked() {
        return this.okClicked;
    }

    private void itemSelected() {
        this.okButton.setEnabled(true);
    }

    private void folderButtonClicked() {
        QFileDialog fileDialog = new QFileDialog();
        fileDialog.setFileMode(QFileDialog.FileMode.DirectoryOnly);
        fileDialog.fileSelected.connect((Object)this, "folderSelected(String)");
        fileDialog.exec();
    }

    private void folderSelected(String f) {
        String whichOS = System.getProperty("os.name");
        if (whichOS.contains("Windows")) {
            f = f.replace('/', '\\');
        }
        this.directory.setText(f);
    }
}

