/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.evernote;

import com.trolltech.qt.core.QByteArray;
import com.trolltech.qt.core.QTextCodec;
import cx.fbn.nevernote.Global;
import cx.fbn.nevernote.evernote.EnCrypt;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import cx.fbn.nevernote.utilities.Pair;
import cx.fbn.nevernote.xml.XMLCleanup;
import cx.fbn.nevernote.xml.XMLNoteRepair;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.w3c.tidy.Tidy;
import org.w3c.tidy.TidyMessage;
import org.w3c.tidy.TidyMessageListener;

public class EnmlConverter {
    private final ApplicationLogger logger;
    private List<String> resources;
    public boolean saveInvalidXML;

    public EnmlConverter(ApplicationLogger l) {
        this.logger = l;
        this.saveInvalidXML = false;
        this.resources = new ArrayList<String>();
    }

    public List<String> getResources() {
        return this.resources;
    }

    public String convert(String noteGuid, String content) {
        int k;
        String newContent;
        this.logger.log(this.logger.HIGH, "Entering DBRunner.convertToEnml");
        this.logger.log(this.logger.EXTREME, "Note Text:" + content);
        content = content.replace("<en-note>", "<body>");
        content = content.replace("</en-note>", "</body>");
        int br = content.lastIndexOf("</body>");
        if (br > 0) {
            content = new String(content.substring(0, br));
        }
        if (!(newContent = (k = content.indexOf("<body")) > -1 ? new String(content.substring(k)) : "<body>" + content).startsWith("<?xml")) {
            newContent = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE en-note SYSTEM \"http://xml.evernote.com/pub/enml2.dtd\">\n" + newContent + "</body>";
        }
        newContent = this.fixStupidXMLProblems(newContent);
        newContent = newContent.replace("<body", "<en-note");
        newContent = newContent.replace("</body>", "</en-note>");
        XMLNoteRepair repair = new XMLNoteRepair();
        this.logger.log(this.logger.HIGH, "Fixing encryption tags");
        newContent = this.fixEncryptionTags(newContent);
        Tidy tidy = new Tidy();
        TidyListener tidyListener = new TidyListener(this.logger);
        tidy.setMessageListener((TidyMessageListener)tidyListener);
        tidy.getStderr().close();
        tidy.setXmlTags(true);
        tidy.setXHTML(true);
        QTextCodec codec = QTextCodec.codecForName((String)"UTF-8");
        QByteArray unicode = codec.fromUnicode(newContent);
        this.logger.log(this.logger.HIGH, "Starting JTidy check");
        this.logger.log(this.logger.EXTREME, "Start of JTidy Input");
        this.logger.log(this.logger.EXTREME, newContent);
        this.logger.log(this.logger.EXTREME, "End Of JTidy Input");
        ByteArrayInputStream is = new ByteArrayInputStream(unicode.toByteArray());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        tidy.setInputEncoding("UTF-8");
        tidy.parse((InputStream)is, (OutputStream)os);
        String tidyContent = os.toString();
        if (tidyListener.errorFound) {
            this.logger.log(this.logger.LOW, "Note Contents Begin");
            this.logger.log(this.logger.LOW, content);
            this.logger.log(this.logger.LOW, "Note Contents End");
            tidyContent = null;
        } else if (newContent.trim().equals("")) {
            tidyContent = null;
        }
        if (tidyContent != null) {
            newContent = tidyContent;
        } else {
            this.logger.log(this.logger.HIGH, "Error converting to JTidy.  Falling back to old method");
            String repairedContent = repair.parse(newContent, false);
            if (repairedContent == null) {
                this.logger.log(this.logger.EXTREME, "Null returned from repair.parse()");
                this.logger.log(this.logger.LOW, "Parse error when converting to ENML. Aborting save");
                return null;
            }
            newContent = repairedContent;
            this.logger.log(this.logger.EXTREME, "Start of repaired content");
            this.logger.log(this.logger.EXTREME, repairedContent);
            this.logger.log(this.logger.EXTREME, "End of repaired content");
        }
        XMLCleanup v = new XMLCleanup();
        v.setValue(newContent);
        this.logger.log(this.logger.HIGH, "Beginning ENML Cleanup");
        v.validate();
        this.logger.log(this.logger.HIGH, "Cleanup complete.");
        this.logger.log(this.logger.EXTREME, "Rebuilt ENML:");
        this.logger.log(this.logger.EXTREME, v.getValue());
        this.logger.log(this.logger.EXTREME, "End Of Rebuilt ENML:");
        this.resources = v.getResources();
        newContent = v.getValue();
        File dtdFile = Global.getFileManager().getXMLDirFile("enml2.dtd");
        String dtd = dtdFile.toURI().toString();
        newContent = newContent.replace("<!DOCTYPE en-note SYSTEM 'http://xml.evernote.com/pub/enml2.dtd'>", "<!DOCTYPE en-note SYSTEM \"" + dtd + "\">");
        this.logger.log(this.logger.HIGH, "Validating ENML");
        String repairedContent = repair.parse(newContent, true);
        if (repairedContent == null) {
            this.logger.log(this.logger.EXTREME, "Null returned from repair.parse()");
        } else {
            newContent = repairedContent;
        }
        this.logger.log(this.logger.HIGH, "Validation complete");
        this.saveInvalidXML = repair.saveInvalidXML;
        newContent = newContent.replace("<!DOCTYPE en-note SYSTEM \"" + dtd + "\">", "<!DOCTYPE en-note SYSTEM 'http://xml.evernote.com/pub/enml2.dtd'>");
        this.logger.log(this.logger.EXTREME, "Leaving ENMLConverter.convert()");
        return newContent;
    }

    private String fixEncryptionTags(String content) {
        String newContent = new String(content);
        this.logger.log(this.logger.MEDIUM, "Inside EnmlConverter.fixEncryptionTags");
        this.logger.log(this.logger.EXTREME, content);
        this.logger.log(this.logger.MEDIUM, "Checking table encryption tags");
        String eTag = "<table class=\"en-crypt-temp\"";
        int i = newContent.indexOf(eTag);
        while (i > 0) {
            int slotStart = newContent.indexOf("slot", i + 1) + 6;
            int slotEnd = newContent.indexOf("\"", slotStart);
            String slot = newContent.substring(slotStart, slotEnd);
            int startPos = newContent.indexOf("<td>", i + 1) + 4;
            int endData = newContent.indexOf("</td>", startPos);
            String text = newContent.substring(startPos, endData);
            int endPos = newContent.indexOf("</table>", i + 1) + 8;
            Pair<String, String> pair = Global.passwordSafe.get(slot);
            String password = pair.getFirst();
            String hint = pair.getSecond();
            EnCrypt crypt = new EnCrypt();
            String encrypted = crypt.encrypt(text, password, 64);
            newContent = String.valueOf(newContent.substring(0, i - 1)) + "<en-crypt-temp cipher=\"RC2\" length=\"64\" hint=\"" + hint + "\" value=\"" + encrypted + "\" />" + newContent.substring(endPos);
            i = newContent.indexOf(eTag, i + 1);
        }
        return newContent;
    }

    public String fixStupidXMLProblems(String content) {
        String end;
        int endPos;
        this.logger.log(this.logger.HIGH, "Entering DBRunner.fixStupidXMLProblems");
        String newContent = new String(content);
        this.logger.log(this.logger.MEDIUM, "Inside fixStupidXMLProblems.  Old content:");
        this.logger.log(this.logger.EXTREME, content);
        this.logger.log(this.logger.MEDIUM, "Checking img tags");
        int i = newContent.indexOf("<img");
        while (i > 0) {
            endPos = newContent.indexOf(">", i + 1);
            end = newContent.substring(endPos + 1);
            newContent = newContent.subSequence(0, endPos) + "/>" + end;
            i = newContent.indexOf("<img", i + 1);
        }
        this.logger.log(this.logger.MEDIUM, "Checking input tags");
        i = newContent.indexOf("<input");
        while (i > 0) {
            endPos = newContent.indexOf(">", i + 1);
            end = newContent.substring(endPos + 1);
            newContent = newContent.subSequence(0, endPos) + "/>" + end;
            i = newContent.indexOf("<input", i + 1);
        }
        this.logger.log(this.logger.MEDIUM, "Checking br tags");
        i = newContent.indexOf("<br");
        while (i > 0) {
            endPos = newContent.indexOf(">", i + 1);
            end = newContent.substring(endPos + 1);
            newContent = newContent.subSequence(0, endPos) + "/>" + end;
            i = newContent.indexOf("<br", i + 1);
        }
        this.logger.log(this.logger.MEDIUM, "Checking hr tags");
        i = newContent.indexOf("<hr");
        while (i > 0) {
            endPos = newContent.indexOf(">", i + 1);
            end = newContent.substring(endPos + 1);
            newContent = newContent.subSequence(0, endPos) + "/>" + end;
            i = newContent.indexOf("<hr", i + 1);
        }
        this.logger.log(this.logger.MEDIUM, "Checking meta tags");
        i = newContent.indexOf("<meta");
        while (i > 0) {
            endPos = newContent.indexOf(">", i + 1);
            end = newContent.substring(endPos + 1);
            newContent = newContent.subSequence(0, endPos) + "/>" + end;
            i = newContent.indexOf("<meta", i + 1);
        }
        this.logger.log(this.logger.MEDIUM, "Leaving fixStupidXMLProblems");
        this.logger.log(this.logger.HIGH, "Leaving DBRunner.fixStupidXMLProblems");
        return newContent.toString();
    }

    public String fixEnXMLCrap(String note) {
        this.logger.log(this.logger.EXTREME, "Entering EnmlConverter.fixEnXMLCrap");
        if (note == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(note);
        this.logger.log(this.logger.EXTREME, "Converting <b/>");
        int pos = buffer.indexOf("<b/>");
        while (pos > -1) {
            buffer.replace(pos, pos + 4, "<b></b>");
            pos = buffer.indexOf("<b/>", pos);
        }
        this.logger.log(this.logger.EXTREME, "converting <br/>");
        pos = buffer.indexOf("<br/>");
        while (pos > -1) {
            buffer.replace(pos, pos + 5, "<br></br>");
            pos = buffer.indexOf("<br/>", pos);
        }
        int endPos = 0;
        pos = buffer.indexOf("<li>");
        int spanPos = buffer.indexOf("<span>");
        pos = buffer.indexOf("<li>");
        spanPos = buffer.indexOf("<span/>");
        while (pos > -1 && spanPos > -1) {
            endPos = buffer.indexOf("</li>", pos);
            if (spanPos > pos && spanPos < endPos) {
                buffer.replace(spanPos, spanPos + 7, "");
            }
            pos = buffer.indexOf("<li>", pos + 1);
            spanPos = buffer.indexOf("<span/>", spanPos);
        }
        this.logger.log(this.logger.EXTREME, "Leaving EnmlConverter.fixEnXMLCrap");
        return buffer.toString();
    }

    public String fixEnMediaCrap(String note) {
        if (note == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(note);
        int pos = buffer.indexOf("</en-media>");
        while (pos > -1) {
            buffer.replace(pos, pos + 11, "");
            pos = buffer.indexOf("</en-media>", pos);
        }
        pos = buffer.indexOf("<en-media");
        while (pos > -1) {
            if (!buffer.substring((pos = buffer.indexOf(">", pos)) - 1, pos).equals("/")) {
                buffer.replace(pos, pos + 1, " />");
            }
            pos = buffer.indexOf("<en-media", pos);
        }
        return buffer.toString();
    }

    private class TidyListener
    implements TidyMessageListener {
        ApplicationLogger logger;
        public boolean errorFound;

        public TidyListener(ApplicationLogger logger) {
            this.logger = logger;
            this.errorFound = false;
        }

        public void messageReceived(TidyMessage msg) {
            if (msg.getLevel() == TidyMessage.Level.ERROR) {
                this.logger.log(this.logger.LOW, "******* JTIDY ERORR *******");
                this.logger.log(this.logger.LOW, "Error Code: " + msg.getErrorCode());
                this.logger.log(this.logger.LOW, "Column: " + msg.getColumn());
                this.logger.log(this.logger.LOW, "Column: " + msg.getColumn());
                this.logger.log(this.logger.LOW, "Line: " + msg.getLine());
                this.logger.log(this.logger.LOW, "Message: " + msg.getMessage());
                this.logger.log(this.logger.LOW, "***************************");
                this.errorFound = true;
            } else {
                this.logger.log(this.logger.EXTREME, "JTidy Results: " + msg.getMessage());
            }
        }
    }
}

