/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.config;

import cx.fbn.nevernote.config.InitializationException;
import java.io.File;
import java.io.FileFilter;
import java.util.regex.Pattern;

public class FileManager {
    private static final Pattern ALL_PATH_SEPARATORS_REGEX = Pattern.compile("[/\\\\]");
    private final String programDirPath;
    private final File programDir;
    private final String homeDirPath;
    private final File homeDir;
    private final String dbDirPath;
    private final File dbDir;
    private final File logsDir;
    private final String imagesDirPath;
    private final File imagesDir;
    private final String spellDirPath;
    private final File spellDir;
    private final String spellDirPathUser;
    private final File spellDirUser;
    private final String qssDirPath;
    private final File qssDir;
    private final String qssDirPathUser;
    private final File qssDirUser;
    private final String resDirPath;
    private final File resDir;
    private final File xmlDir;
    private final String translateDirPath;
    private final File translateDir;

    public FileManager(String homeDirPath, String programDirPath) throws InitializationException {
        if (homeDirPath == null) {
            throw new IllegalArgumentException("homeDirPath must not be null");
        }
        if (programDirPath == null) {
            throw new IllegalArgumentException("programDirPath must not be null");
        }
        this.homeDir = new File(FileManager.toPlatformPathSeparator(homeDirPath));
        this.programDir = new File(FileManager.toPlatformPathSeparator(programDirPath));
        FileManager.createDirOrCheckWriteable(this.homeDir);
        this.homeDirPath = FileManager.slashTerminatePath(this.homeDir.getPath());
        this.programDirPath = FileManager.slashTerminatePath(this.programDir.getPath());
        this.imagesDir = new File(this.programDir, "images");
        FileManager.checkExistingReadableDir(this.imagesDir);
        this.imagesDirPath = FileManager.slashTerminatePath(this.imagesDir.getPath());
        this.qssDir = new File(this.programDir, "qss");
        FileManager.checkExistingReadableDir(this.qssDir);
        this.qssDirPath = FileManager.slashTerminatePath(this.qssDir.getPath());
        this.qssDirUser = new File(this.homeDir, "qss");
        FileManager.createDirOrCheckWriteable(this.qssDirUser);
        this.qssDirPathUser = FileManager.slashTerminatePath(this.qssDirUser.getPath());
        this.spellDir = new File(this.programDir, "spell");
        FileManager.checkExistingReadableDir(this.spellDir);
        this.spellDirPath = FileManager.slashTerminatePath(this.spellDir.getPath());
        this.spellDirUser = new File(this.homeDir, "spell");
        FileManager.createDirOrCheckWriteable(this.spellDirUser);
        this.spellDirPathUser = FileManager.slashTerminatePath(this.spellDirUser.getPath());
        this.xmlDir = new File(this.programDir, "xml");
        FileManager.checkExistingReadableDir(this.xmlDir);
        this.translateDir = new File(this.programDir, "translations");
        FileManager.checkExistingReadableDir(this.translateDir);
        this.translateDirPath = FileManager.slashTerminatePath(this.translateDir.getPath());
        this.dbDir = new File(this.homeDir, "db");
        FileManager.createDirOrCheckWriteable(this.dbDir);
        this.dbDirPath = FileManager.slashTerminatePath(this.dbDir.getPath());
        this.logsDir = new File(this.homeDir, "logs");
        FileManager.createDirOrCheckWriteable(this.logsDir);
        this.resDir = new File(this.homeDir, "res");
        FileManager.createDirOrCheckWriteable(this.resDir);
        this.resDirPath = FileManager.slashTerminatePath(this.resDir.getPath());
    }

    public File getProgramDirFile(String relativePath) {
        return new File(this.programDir, FileManager.toPlatformPathSeparator(relativePath));
    }

    public String getProgramDirPath(String relativePath) {
        return String.valueOf(this.programDirPath) + FileManager.toPlatformPathSeparator(relativePath);
    }

    public File getHomeDirFile(String relativePath) {
        return new File(this.homeDir, FileManager.toPlatformPathSeparator(relativePath));
    }

    public String getHomeDirPath(String relativePath) {
        return String.valueOf(this.homeDirPath) + FileManager.toPlatformPathSeparator(relativePath);
    }

    public File getDbDirFile(String relativePath) {
        return new File(this.dbDir, FileManager.toPlatformPathSeparator(relativePath));
    }

    public String getSpellDirPath(String relativePath) {
        return String.valueOf(this.dbDirPath) + FileManager.toPlatformPathSeparator(relativePath);
    }

    public File getSpellDirFile(String relativePath) {
        return new File(this.spellDir, FileManager.toPlatformPathSeparator(relativePath));
    }

    public String getSpellDirPath() {
        return this.spellDirPath;
    }

    public File getSpellDirFileUser(String relativePath) {
        return new File(this.spellDirUser, FileManager.toPlatformPathSeparator(relativePath));
    }

    public String getSpellDirPathUser() {
        return this.spellDirPathUser;
    }

    public String getDbDirPath(String relativePath) {
        return String.valueOf(this.dbDirPath) + FileManager.toPlatformPathSeparator(relativePath);
    }

    public File getImageDirFile(String relativePath) {
        return new File(this.imagesDir, FileManager.toPlatformPathSeparator(relativePath));
    }

    public String getImageDirPath(String relativePath) {
        return String.valueOf(this.imagesDirPath) + FileManager.toPlatformPathSeparator(relativePath);
    }

    public File getLogsDirFile(String relativePath) {
        return new File(this.logsDir, FileManager.toPlatformPathSeparator(relativePath));
    }

    public String getQssDirPath(String relativePath) {
        return String.valueOf(this.qssDirPath) + FileManager.toPlatformPathSeparator(relativePath);
    }

    public String getQssDirPathUser(String relativePath) {
        return String.valueOf(this.qssDirPathUser) + FileManager.toPlatformPathSeparator(relativePath);
    }

    public String getResDirPath() {
        return this.resDirPath;
    }

    public String getResDirPath(String relativePath) {
        return String.valueOf(this.resDirPath) + FileManager.toPlatformPathSeparator(relativePath);
    }

    public String getResDirPathSpecialChar(String relativePath) {
        return String.valueOf(this.resDirPath) + FileManager.toPlatformPathSeparator(relativePath).replace("#", "%23");
    }

    public File getXMLDirFile(String relativePath) {
        return new File(this.xmlDir, FileManager.toPlatformPathSeparator(relativePath));
    }

    public String getTranslateFilePath(String relativePath) {
        return String.valueOf(this.translateDirPath) + FileManager.toPlatformPathSeparator(relativePath);
    }

    public static String toPlatformPathSeparator(String relativePath) {
        relativePath = relativePath.replace("%20", " ");
        return ALL_PATH_SEPARATORS_REGEX.matcher(relativePath).replaceAll(File.separator.equals("\\") ? "\\\\" : File.separator);
    }

    public static String slashTerminatePath(String path) {
        if (!path.substring(path.length() - 1).equals(File.separator)) {
            return String.valueOf(path) + File.separator;
        }
        return path;
    }

    private static void deleteTopLevelFiles(File dir, boolean exitOnFail) throws InitializationException {
        File[] toDelete;
        File[] fileArray = toDelete = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile();
            }
        });
        int n = toDelete.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (!f.delete() && exitOnFail) {
                throw new InitializationException("Failed to delete file: '" + f + "'");
            }
            ++n2;
        }
    }

    private static void createDirOrCheckWriteable(File dir) throws InitializationException {
        if (dir.isDirectory()) {
            if (!dir.canRead()) {
                throw new InitializationException("Directory '" + dir + "' does not have read permission");
            }
            if (!dir.canWrite()) {
                throw new InitializationException("Directory '" + dir + "' does not have write permission");
            }
        } else if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new InitializationException("Failed to create directory '" + dir + "'");
            }
        } else {
            throw new InitializationException("Expected directory '" + dir + "' but found a file instead");
        }
    }

    private static void checkExistingReadableDir(File dir) throws InitializationException {
        if (dir.isDirectory()) {
            if (!dir.canRead()) {
                throw new InitializationException("Directory '" + dir + "' does not have read permission");
            }
        } else {
            if (!dir.exists()) {
                throw new InitializationException("Directory '" + dir + "' does not exist");
            }
            throw new InitializationException("Expected directory '" + dir + "' but found a file instead");
        }
    }

    private static void checkExistingWriteableDir(File dir) throws InitializationException {
        FileManager.checkExistingReadableDir(dir);
        if (!dir.canWrite()) {
            throw new InitializationException("Directory '" + dir + "' does not have write permission");
        }
    }

    public void purgeResDirectory(boolean exitOnFail) throws InitializationException {
        FileManager.deleteTopLevelFiles(this.resDir, exitOnFail);
    }
}

