/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.threads;

import com.evernote.edam.type.Note;
import com.trolltech.qt.core.QMutex;
import com.trolltech.qt.core.QObject;
import cx.fbn.nevernote.filters.NotebookCounter;
import cx.fbn.nevernote.filters.TagCounter;
import cx.fbn.nevernote.signals.NotebookSignal;
import cx.fbn.nevernote.signals.TagSignal;
import cx.fbn.nevernote.signals.TrashSignal;
import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;

public class CounterRunner
extends QObject
implements Runnable {
    private final ApplicationLogger logger;
    private volatile boolean keepRunning;
    public int ID;
    public volatile NotebookSignal notebookSignal;
    public volatile TrashSignal trashSignal;
    public volatile TagSignal tagSignal;
    private volatile Vector<NoteRecord> records;
    public int type;
    public QMutex threadLock;
    public static int EXIT = 0;
    public static int NOTEBOOK = 1;
    public static int TAG = 2;
    public static int TRASH = 3;
    public boolean ready = false;
    public boolean abortCount = false;
    private final DatabaseConnection conn;
    private volatile LinkedBlockingQueue<Integer> readyQueue = new LinkedBlockingQueue();

    public CounterRunner(String logname, int t, String u, String i, String r, String b, String uid, String pswd, String cpswd) {
        this.type = t;
        this.threadLock = new QMutex();
        this.logger = new ApplicationLogger(logname);
        this.conn = new DatabaseConnection(this.logger, u, i, r, b, uid, pswd, cpswd, 300);
        this.keepRunning = true;
        this.notebookSignal = new NotebookSignal();
        this.tagSignal = new TagSignal();
        this.trashSignal = new TrashSignal();
        this.records = new Vector();
    }

    @Override
    public void run() {
        boolean keepRunning = true;
        this.thread().setPriority(1);
        while (keepRunning) {
            this.ready = true;
            try {
                this.type = this.readyQueue.take();
                this.threadLock.lock();
                if (this.type == EXIT) {
                    keepRunning = false;
                }
                if (this.type == NOTEBOOK) {
                    this.countNotebookResults();
                }
                if (this.type == TAG) {
                    this.countTagResults();
                }
                if (this.type == TRASH) {
                    this.countTrashResults();
                }
                this.threadLock.unlock();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.conn.dbShutdown();
    }

    public void setNoteIndex(List<Note> idx) {
        this.abortCount = true;
        this.threadLock.lock();
        this.abortCount = false;
        this.records.clear();
        if (idx != null) {
            int i = 0;
            while (i < idx.size()) {
                if (this.abortCount) {
                    return;
                }
                NoteRecord record = new NoteRecord();
                record.notebookGuid = new String(idx.get(i).getNotebookGuid());
                record.active = idx.get(i).isActive();
                int j = 0;
                while (j < idx.get(i).getTagGuidsSize()) {
                    if (this.abortCount) {
                        return;
                    }
                    record.tags.add(new String((String)idx.get(i).getTagGuids().get(j)));
                    ++j;
                }
                this.records.add(record);
                ++i;
            }
        }
        this.threadLock.unlock();
    }

    public void release(int type) {
        this.readyQueue.add(type);
    }

    public void setKeepRunning(boolean b) {
        this.keepRunning = b;
    }

    public boolean keepRunning() {
        return this.keepRunning;
    }

    private void countNotebookResults() {
        this.logger.log(this.logger.EXTREME, "Entering ListManager.countNotebookResults");
        if (this.abortCount) {
            return;
        }
        ArrayList<NotebookCounter> nCounter = new ArrayList<NotebookCounter>();
        int i = 0;
        while (i < this.records.size()) {
            if (this.abortCount) {
                return;
            }
            boolean found = false;
            int j = 0;
            while (j < nCounter.size()) {
                if (this.abortCount) {
                    return;
                }
                if (this.records.get((int)i).active && ((NotebookCounter)nCounter.get(j)).getGuid().equals(this.records.get((int)i).notebookGuid)) {
                    ((NotebookCounter)nCounter.get(j)).setCount(((NotebookCounter)nCounter.get(j)).getCount() + 1);
                    found = true;
                    j = nCounter.size();
                }
                ++j;
            }
            if (!found && this.records.get((int)i).active) {
                NotebookCounter newCounter = new NotebookCounter();
                newCounter.setGuid(this.records.get((int)i).notebookGuid);
                newCounter.setCount(1);
                nCounter.add(newCounter);
            }
            ++i;
        }
        if (this.abortCount) {
            return;
        }
        this.notebookSignal.countsChanged.emit(nCounter);
        this.logger.log(this.logger.EXTREME, "Leaving ListManager.countNotebookResults()");
    }

    private void countTagResults() {
        this.logger.log(this.logger.EXTREME, "Entering ListManager.countTagResults");
        if (this.abortCount) {
            return;
        }
        ArrayList<TagCounter> tCounter = new ArrayList<TagCounter>();
        int i = 0;
        while (i < this.records.size()) {
            if (this.abortCount) {
                return;
            }
            Vector<String> tags = this.records.get((int)i).tags;
            int z = 0;
            while (z < tags.size()) {
                boolean found = false;
                int j = 0;
                while (j < tCounter.size()) {
                    if (this.abortCount) {
                        return;
                    }
                    if (((TagCounter)tCounter.get(j)).getGuid().equals(tags.get(z))) {
                        ((TagCounter)tCounter.get(j)).setCount(((TagCounter)tCounter.get(j)).getCount() + 1);
                        found = true;
                        j = tCounter.size();
                    }
                    ++j;
                }
                if (!found) {
                    TagCounter newCounter = new TagCounter();
                    newCounter.setGuid(tags.get(z));
                    newCounter.setCount(1);
                    tCounter.add(newCounter);
                }
                ++z;
            }
            ++i;
        }
        if (this.abortCount) {
            return;
        }
        this.tagSignal.countsChanged.emit(tCounter);
        this.logger.log(this.logger.EXTREME, "Leaving ListManager.countTagResults");
    }

    private void countTrashResults() {
        this.logger.log(this.logger.EXTREME, "Entering CounterRunner.countTrashResults()");
        if (this.abortCount) {
            return;
        }
        int tCounter = 0;
        int i = 0;
        while (i < this.records.size()) {
            if (this.abortCount) {
                return;
            }
            if (!this.records.get((int)i).active) {
                ++tCounter;
            }
            ++i;
        }
        if (this.abortCount) {
            return;
        }
        this.trashSignal.countChanged.emit((Object)tCounter);
        this.logger.log(this.logger.EXTREME, "Leaving CounterRunner.countTrashResults()");
    }

    private class NoteRecord {
        public String notebookGuid;
        public Vector<String> tags = new Vector();
        public boolean active;
    }
}

