# This program is distributed under the terms of the
# GNU General Public License, version 2.
#
# Nekorum is forum additional plugin for MTOS/MT4.1 later.
# Original Copyright (c) 2008 nekotama (http://nekotama.org/)
#
# $Id: Profile.pm 47 2008-05-15 06:22:04Z nekotama $

package Nekorum::App::Profile;

use strict;

use MT;
use Nekorum::Util;

sub _edit_profile {
	my $app = shift;

	my $blog_id = $app->param('blog_id');
	my $commenter_id = $app->cookie_val('commenter_id') or return $app->errtrans("Permission denied.");
	my @author_blog_ids = split(/:/, $commenter_id) or return $app->errtrans("Permission denied.");
	my $author_id = @author_blog_ids[0] or return $app->errtrans("Permission denied.");

	# load blog
	require MT::Blog;
	my $blog = MT::Blog->load($blog_id);

	# author session
	my $author = Nekorum::Util->_get_author($app, $author_id);
	return $app->errtrans("Session timeout.") unless($author);
	$app->{author} = $author;
}

1;