# This program is distributed under the terms of the
# GNU General Public License, version 2.
#
# Nekorum is forum additional plugin for MTOS/MT4.1 later.
# Original Copyright (c) 2008 nekotama (http://nekotama.org/)
#
# $Id: Profile.pm 47 2008-05-15 06:22:04Z nekotama $

package Nekorum::CMS::Profile;

use strict;

use MT;
use Nekorum::Util;

sub _view_edit_profile {
	my $app = shift;

	my $blog_id = $app->param('blog_id');
	my $category_id = $app->param('category_id') or retrun $app->errtrans("Invalid parameter");

	# author session
	my $author = Nekorum::Util->_get_author($app);
	return $app->errtrans("Session timeout.") unless($author);
	$app->{author} = $author;
	my $author_id = $author->id;

	# load blog
	require MT::Blog;
	my $blog = MT::Blog->load($blog_id);

	# load template
	require MT::Template;
	my $tmpl = MT::Template->load({ blog_id => $blog_id, type => 'custom', name => 'Nekorum Profile'}) or return $app->errtrans("Load template error.");

	require MT::Template::Context;
	my $ctx = MT::Template::Context->new;
	my %cond;
	$ctx->stash('blog', $blog);
	$ctx->stash('author', $author);
	$ctx->var('blog_id', $blog_id);
	$ctx->var('category_id', $category_id);
	$ctx->var('author_id', $author_id);
	$ctx->var('mode', '_post_topic');

	my $output = $tmpl->build($ctx, \%cond) or return $tmpl->errstr;
	return $output;
}

1;