# This program is distributed under the terms of the
# GNU General Public License, version 2.
#
# Nekorum is forum additional plugin for MTOS/MT4.1 later.
# Original Copyright (c) 2008 nekotama (http://nekotama.org/)
#
# $Id: Block.pm 55 2008-05-16 07:27:24Z nekotama $

package Nekorum::Tags::Block;
use strict;

use MT;

sub NekorumAuthorEntryBlock {
	my ($ctx, $args, $cond) = @_;
	
	my $app = MT->instance;
	my $blog = $ctx->stash('blog');
	my $blog_id = $ctx->stash('blog_id');
	my $entry = $ctx->stash('entry');
	my $entry_id = $entry->id;
	my $author_id = $entry->author_id;
	my $builder = $ctx->stash('builder');
	my $tokens = $ctx->stash('tokens');
	my $type = $args->{type} ? $args->{type} : $blog->file_extension;
	my $output = $builder->build($ctx,$tokens,$cond);
	my $before;
	my $after;
	if($type eq 'php'){
		$before = <<PHP_BEFORE;
		<span style="display : <?php
		\$cookieName = 'commenter_id';
		\$commenter_id=\$_COOKIE[\$cookieName];
		if(\$commenter_id){
			\$id = split(':',\$commenter_id);
			if($author_id!=\$id[0]){
				echo("none;");
			}
		} else {
			echo("none;");
		}
		?>">
PHP_BEFORE

		$after = '</span>';
	} else {
		$before = <<HTML_BEFORE;
<span id="nekorum_author_entry_$entry_id">
HTML_BEFORE
		
		$after = <<HTML_AFTER;
		</span>
<script type="text/javascript">
/* <![CDATA[ */
function show_commenter_entry_$entry_id() {
	var id, ids, element;
	
	element = document.getElementById("nekorum_author_entry_$entry_id");
	if(typeof(commenter_id) != 'undefined'){
		ids = getCookie('commenter_id').split(':');
		id = ids[0];
		if(id != $author_id){
			element.style.display='none';
		}
	} else {
		element.style.display='none';
	}
}
show_commenter_entry_$entry_id();
/* ]]> */
</script>
HTML_AFTER
	}
	return $before . $output . $after;
}

sub NekorumAuthorCommentBlock {
	my ($ctx, $args, $cond) = @_;
	
	my $app = MT->instance;
	my $blog = $ctx->stash('blog');
	my $blog_id = $ctx->stash('blog_id');
	my $comment = $ctx->stash('comment');
	my $comment_id = $comment->id;
	my $commenter_id = $comment->commenter_id || -1;
	my $builder = $ctx->stash('builder');
	my $tokens = $ctx->stash('tokens');
	my $type = $args->{type} ? $args->{type} : $blog->file_extension;
	my $output = $builder->build($ctx,$tokens,$cond);
	my $before;
	my $after;

	if($type eq 'php'){
		$before = <<PHP_BEFORE;
		<span style="display : <?php
		\$cookieName = 'commenter_id';
		\$commenter_id=\$_COOKIE[\$cookieName];
		if(\$commenter_id){
			\$id = split(':',\$commenter_id);
			if($commenter_id!=\$id[0]){
				echo("none;");
			}
		} else {
			echo("none;");
		}
		?>">
PHP_BEFORE

		$after = '</span>';
	} else {
		$before = <<HTML_BEFORE;
<span id="nekorum_author_comment_$comment_id">
HTML_BEFORE
		
		$after = <<HTML_AFTER;
		</span>
<script type="text/javascript">
/* <![CDATA[ */
function show_commenter_$comment_id() {
	var id, ids, element;

	element = document.getElementById("nekorum_author_comment_$comment_id");
	if(typeof(commenter_id) != 'undefined'){
		ids = getCookie('commenter_id').split(':');
		id = ids[0];
		if(id != $commenter_id){
			element.style.display='none';
		}
	} else {
		element.style.display='none';
	}
}
show_commenter_$comment_id();
/* ]]> */
</script>
HTML_AFTER
	}
	return $before . $output . $after;
}

1;
