# This program is distributed under the terms of the
# GNU General Public License, version 2.
#
# Nekorum is forum additional plugin for MTOS/MT4.1 later.
# Original Copyright (c) 2008 nekotama (http://nekotama.org/)
#
# $Id: Util.pm 47 2008-05-15 06:22:04Z nekotama $

package Nekorum::CMS::Util;

use strict;

use MT;
use Nekorum::Util;

sub _view_template {
	my $app = shift;

	my $blog_id = $app->param('blog_id') or $app->errtrans('Invalid parameter.');
	my $entry_id = $app->param('entry_id') or undef;
	my $category_id = $app->param('category_id') or undef;
	my $author_id = $app->param('author_id') or undef;
	my $comment_id = $app->param('comment_id') or undef;
	
	my $templ_name = $app->param('tmpl') or $app->errtrans('Invalid parameter.');
	my $session = $app->param('session') or undef;
	my $author;
	
	my %param = $app->param_hash;
	
	# author session
	if($session){
		$author = Nekorum::Util->_get_author($app);
		return $app->errtrans("Session timeout.") unless($author);
	} else {
		# load blog
		require MT::Author;
		$author = MT::Author->load($author_id) if($author_id);
	}

	# load blog
	require MT::Blog;
	my $blog = MT::Blog->load($blog_id) if($blog_id);

	# load entry
	require MT::Entry;
	my $entry = MT::Entry->load($entry_id) if($entry_id);

	# load category
	require MT::Category;
	my $category = MT::Category->load($category_id) if($category_id);

	# load comment
	require MT::Comment;
	my $comment = MT::Comment->load($comment_id) if($comment_id);

	# load template
	require MT::Template;
	my $tmpl = MT::Template->load({ blog_id => $blog_id, type => 'custom', name => $templ_name}) or return $app->errtrans("Load template error.");

	require MT::Template::Context;
	my $ctx = MT::Template::Context->new;
	my %cond;
	$ctx->stash('blog', $blog);
	$ctx->stash('entry', $entry) if($entry);
	$ctx->stash('category', $category) if($category);
	$ctx->stash('author', $author) if($author);
	$ctx->stash('comment', $comment) if($comment);

	my ($name, $value);
	while (($name, $value) = each(%param)){
		$ctx->var($name,$value);
	}

	my $output = $tmpl->build($ctx, \%cond) or return $tmpl->errstr;
	return $output;
}

1;