# This program is distributed under the terms of the
# GNU General Public License, version 2.
#
# Nekorum is forum additional plugin for MTOS/MT4.1 later.
# Original Copyright (c) 2008 nekotama (http://nekotama.org/)
#
# $Id: Topic.pm 91 2008-05-21 14:24:29Z nekotama $

package Nekorum::CMS::Topic;

use strict;

use MT;
use Nekorum::Util;

sub _get_author_js {
	local $SIG{__WARN__} = sub { };
	my $app = shift;

	my $blog_id = $app->param('blog_id');
	my $entry_id = $app->param('entry_id') or undef;
	my $author_id = $app->param('author_id') or undef;

	# author session
	my $author = Nekorum::Util->_get_author($app);
	my $display = ($author && ($author->id == $author_id)) ? 'inline' : 'none';

	$app->{no_print_body} = 1;
	$app->send_http_header("text/javascript");

	my $output = <<JAVA;
function hide_author_$entry_id(element){
	element.style.display = '$display';
}
JAVA
	$app->print("$output");

return undef;
}

sub _view_post_topic {
	my $app = shift;

	my $blog_id = $app->param('blog_id');
	my $category_id = $app->param('category_id') or return $app->errtrans("Invalid parameter");

	# author session
	my $author = Nekorum::Util->_get_author($app);
	return $app->errtrans("Session timeout.") unless($author);
	$app->{author} = $author;
	my $author_id = $author->id;

	# load blog
	require MT::Blog;
	my $blog = MT::Blog->load($blog_id);

	# load template
	require MT::Template;
	my $tmpl = MT::Template->load({ blog_id => $blog_id, type => 'custom', name => 'Nekorum Topic'}) or return $app->errtrans("Load template error.");

	require MT::Template::Context;
	my $ctx = MT::Template::Context->new;
	my %cond;
	$ctx->stash('blog', $blog);
	$ctx->stash('author', $author);
	$ctx->var('blog_id', $blog_id);
	$ctx->var('category_id', $category_id);
	$ctx->var('author_id', $author_id);
	$ctx->var('mode', '_post_topic');

	my $output = $tmpl->build($ctx, \%cond) or return $tmpl->errstr;
	return $output;
}

sub _view_edit_topic {
	my $app = shift;

	my $blog_id = $app->param('blog_id');
	my $entry_id = $app->param('entry_id') or return $app->errtrans("Invalid parameter");
	my $category_id = $app->param('category_id') or undef;

	# author session
	my $author = Nekorum::Util->_get_author($app);
	return $app->errtrans("Session timeout.") unless($author);
	$app->{author} = $author;
	my $author_id = $author->id;

	# load blog
	require MT::Blog;
	my $blog = MT::Blog->load(id => $blog_id);

	# load category
	require MT::Category;
	my $category = MT::Category->load($category_id) if($category_id);

	# load entry
	require MT::Entry;
	my $entry = MT::Entry->load({blog_id => $blog_id, id => $entry_id});
	return $app->errtrans("Permission denied.") if($entry->author_id!=$author_id);

	# load tags
	require MT::Tag;
	my $tag_delim = chr($author->entry_prefs->{tag_delim});
	my $tags = MT::Tag->join($tag_delim, $entry->tags);
	
	# load template
	require MT::Template;
	my $tmpl = MT::Template->load({ blog_id => $blog_id, type => 'custom', name => 'Nekorum Topic'}) or return $app->errtrans("Load template error.");

	require MT::Template::Context;
	my $ctx = MT::Template::Context->new;
	my %cond;
	$ctx->stash('blog', $blog);
	$ctx->stash('entry', $entry);
	$ctx->stash('author', $author);
	$ctx->var('blog_id', $blog_id);
	$ctx->var('author_id', $author_id);
	$ctx->var('entry_id', $entry_id);
	$ctx->var('mode', '_edit_topic');
	$ctx->var('topic_title', $entry->title);
	$ctx->var('topic_text', $entry->text);
	$ctx->var('topic_keywords', $entry->keywords);
	$ctx->var('topic_tags', $tags);

	my $output = $tmpl->build($ctx, \%cond) or return $tmpl->errstr;
	return $output;
}

1;