# This program is distributed under the terms of the
# GNU General Public License, version 2.
#
# Nekorum is forum additional plugin for MTOS/MT4.1 later.
# Original Copyright (c) 2008 nekotama (http://nekotama.org/)
#
# $Id: Function.pm 84 2008-05-19 05:59:07Z nekotama $

package Nekorum::Tags::Function;
use strict;

use MT::App;
use MT::Object;
use MT::Category;
use MT::Author;

sub NekorumScriptPath {
	my ($ctx, $args, $cond) = @_;
	my $app = MT->instance;

	my $output = $app->base . $app->path . 'plugins/Nekorum/nekorum-post.cgi';
	return $output;
}

sub NekorumPostTopicPath {
	my ($ctx, $args, $cond) = @_;
	my $app = MT->instance;
	
	my $blog_id = $ctx->stash('blog_id');
	my $category = $ctx->stash('archive_category') or return $ctx->error(MT->Trance("Tag called without an archive category in context"));
	my $output = $app->base . $app->path . 'plugins/Nekorum/nekorum-post.cgi?__mode=_view_post_topic&amp;blog_id=' . $blog_id . '&amp;category_id=' . $category->id;
	return $output;
}

sub NekorumEditTopicPath {
	my ($ctx, $args, $cond) = @_;
	my $app = MT->instance;
	
	my $blog_id = $ctx->stash('blog_id');
	my $entry = $ctx->stash('entry') or return $ctx->error(MT->Trance("Tag called without an entry in context"));
	my $category = $ctx->stash('category');
	my $output = $app->base . $app->path . 'plugins/Nekorum/nekorum-post.cgi?__mode=_view_edit_topic&amp;blog_id=' . $blog_id . '&amp;entry_id=' . $entry->id;
	return $output;
}

sub NekorumRemoveTopicPath {
	my ($ctx, $args, $cond) = @_;
	my $app = MT->instance;
	
	my $blog_id = $ctx->stash('blog_id');
	my $entry = $ctx->stash('entry') or return $ctx->error(MT->Trance("Tag called without an entry in context"));
	my $output = $app->base . $app->path . 'plugins/Nekorum/nekorum-post.cgi?__mode=_remove_topic&amp;blog_id=' . $blog_id . '&amp;entry_id=' . $entry->id;
	return $output;
}

sub NekorumFreezeTopicPath {
	my ($ctx, $args, $cond) = @_;
	my $app = MT->instance;
	
	my $blog_id = $ctx->stash('blog_id');
	my $entry = $ctx->stash('entry') or return $ctx->error(MT->Trance("Tag called without an entry in context"));
	my $output = $app->base . $app->path . 'plugins/Nekorum/nekorum-post.cgi?__mode=_freeze_topic&amp;blog_id=' . $blog_id . '&amp;entry_id=' . $entry->id;
	return $output;
}

sub NekorumPostCommentPath {
	my ($ctx, $args, $cond) = @_;
	my $app = MT->instance;

	my $blog_id = $ctx->stash('blog_id');
	my $entry = $ctx->stash('entry') or return $ctx->error(MT->Trance("Tag called without an entry in context"));
	my $is_quote = $args->{quote} or undef;
	my $comment = $ctx->stash('comment') or undef;

	my $output;
	if($is_quote){
		if($comment){
			$output = $app->path . 'plugins/Nekorum/nekorum-post.cgi?__mode=_view_post_comment&amp;quote=1&amp;blog_id=' . $blog_id . '&amp;entry_id=' . $entry->id . '&amp;comment_id=' . $comment->id;
		} else {
			$output = $app->path . 'plugins/Nekorum/nekorum-post.cgi?__mode=_view_post_comment&amp;quote=1&amp;blog_id=' . $blog_id . '&amp;entry_id=' . $entry->id;
		}
	} else {
		$output = $app->base . $app->path . 'plugins/Nekorum/nekorum-post.cgi?__mode=_view_post_comment&amp;blog_id=' . $blog_id . '&amp;entry_id=' . $entry->id;
	}
	return $output;
}

sub NekorumEditCommentPath {
	my ($ctx, $args, $cond) = @_;
	my $app = MT->instance;
	
	my $blog_id = $ctx->stash('blog_id');
	my $entry = $ctx->stash('entry') or return $ctx->error(MT->Trance("Tag called without an entry in context"));
	my $comment = $ctx->stash('comment') or return $ctx->error(MT->Trance("Tag called without an comment in context"));
	my $output = $app->base . $app->path . 'plugins/Nekorum/nekorum-post.cgi?__mode=_view_edit_comment&amp;blog_id=' . $blog_id . '&amp;entry_id=' . $entry->id . '&amp;comment_id=' . $comment->id;
	return $output;
}

sub NekorumRemoveCommentPath {
	my ($ctx, $args, $cond) = @_;
	my $app = MT->instance;
	
	my $blog_id = $ctx->stash('blog_id');
	my $entry = $ctx->stash('entry') or return $ctx->error(MT->Trance("Tag called without an entry in context"));
	my $comment = $ctx->stash('comment') or return $ctx->error(MT->Trance("Tag called without an comment in context"));
	my $output = $app->base . $app->path . 'plugins/Nekorum/nekorum-post.cgi?__mode=_remove_comment&amp;blog_id=' . $blog_id . '&amp;entry_id=' . $entry->id . '&amp;comment_id=' . $comment->id;
	return $output;
}

sub NekorumSigninPath {
	my ($ctx, $args, $cond) = @_;
	my $app = MT->instance;
	
	my $blog_id = $ctx->stash('blog_id');
	my $blog = $ctx->stash('blog');
	my $entry = $ctx->stash('entry') or undef;
	my $category = $ctx->stash('archive_category') or undef;
	my $static = $blog->site_url;
	$static = $entry->permalink if($entry);
	$static = $ctx->_hdlr_category_archive if($category);
	my $output = $app->base . $app->path . 'plugins/Nekorum/nekorum-post.cgi?__mode=_view_signin&amp;blog_id=' . $blog_id . '&amp;static=' . $static;
	return $output;
}

sub NekorumEditProfilePath {
	my ($ctx, $args, $cond) = @_;
	my $app = MT->instance;
	
	my $blog_id = $ctx->stash('blog_id');
	my $output = $app->base . $app->path . 'plugins/Nekorum/nekorum-post.cgi?__mode=_view_edit_profile&amp;blog_id=' . $blog_id;
	return $output;
}

sub NekorumViewTemplatePath {
	my ($ctx, $args, $cond) = @_;
	my $app = MT->instance;
	
	my $blog_id = $ctx->stash('blog_id');
	my $output = $app->base . $app->path . 'plugins/Nekorum/nekorum-post.cgi?__mode=_view_template&amp;blog_id=' . $blog_id;
	
	my $name;
	foreach $name (keys(%$args)){
		$output .= '&amp;' . $name . '=' . $args->{$name} if($name ne '@');
	}
	
	return $ctx->error("Undefined template name.") if(!$args->{tmpl});
	my $category = $args->{category_id} ? undef : $ctx->stash('archive_category') ? '&amp;category_id=' . $ctx->stash('archive_category')->id : undef;
	my $entry = $args->{entry_id} ? undef : $ctx->stash('entry') ? '&amp;entry_id=' . $ctx->stash('entry')->id : undef;
	my $comment = $args->{comment_id} ? undef : $ctx->stash('comment') ? '&amp;comment_id=' . $ctx->stash('comment')->id : undef;
	my $author = $args->{autor_id} ? undef : $ctx->stash('author') ? '&amp;author_id=' . $ctx->stash('author')->id : undef;
	return $output . $category . $entry . $comment . $author;
}

1;
