# This program is distributed under the terms of the
# GNU General Public License, version 2.
#
# Nekorum is forum additional plugin for MTOS/MT4.1 later.
# Original Copyright (c) 2008 nekotama (http://nekotama.org/)
#
# $Id: Nekorum.pm 84 2008-05-19 05:59:07Z nekotama $

package Nekorum;

use strict;
use base qw(MT::App);

use MT;

sub init {
	my $app = shift;
	$app->SUPER::init(@_) or return;
	$app->add_methods(
		'_login'	=> 'Nekorum::App::User::_login',
		'_post_topic'	=> 'Nekorum::App::Topic::_post_topic',
		'_edit_topic'	=> 'Nekorum::App::Topic::_edit_topic',
		'_remove_topic'	=> 'Nekorum::App::Topic::_remove_topic',
		'_freeze_topic'	=> 'Nekorum::App::Topic::_freeze_topic',
		'_post_comment'	=> 'Nekorum::App::Comment::_post_comment',
		'_edit_comment'	=> 'Nekorum::App::Comment::_edit_comment',
		'_remove_comment'	=> 'Nekorum::App::Comment::_remove_comment',
		'_edit_profile'	=> 'Nekorum::App::Profile::_edit_profile',
		'_view_post_topic'	=> 'Nekorum::CMS::Topic::_view_post_topic',
		'_view_edit_topic'	=> 'Nekorum::CMS::Topic::_view_edit_topic',
		'_view_post_comment'	=> 'Nekorum::CMS::Comment::_view_post_comment',
		'_view_edit_comment'	=> 'Nekorum::CMS::Comment::_view_edit_comment',
		'_view_signin'	=> 'Nekorum::CMS::Signin::_view_signin',
		'_view_edit_profile'	=> 'Nekorum::CMS::Profile::_view_edit_profile',
		'_view_template'	=> 'Nekorum::CMS::Util::_view_template',
		'_get_author_js'	=> 'Nekorum::CMS::Topic::_get_author_js',
		'_get_commenter_js'	=> 'Nekorum::CMS::Comment::_get_commenter_js',
	);
	$app->{charset} = $app->{cfg}->PublishCharset;
	$app;
}

sub plugin {
    MT::Plugin::Nekorum->instance;
}

sub translate_templatized {
    my $app = shift;
    $app->plugin->translate_templatized(@_);
}

1;
