# This program is distributed under the terms of the
# GNU General Public License, version 2.
#
# Nekorum is forum additional plugin for MTOS/MT4.1 later.
# Original Copyright (c) 2008 nekotama (http://nekotama.org/)
#
# $Id: User.pm 47 2008-05-15 06:22:04Z nekotama $

package Nekorum::App::User;

use strict;

use MT;

sub _login {
	my $app = shift;

	my $blog_id = $app->param('blog_id');
	my $commenter_id = $app->cookie_val('commenter_id') or return $app->errtrans("Permission denied.");
	my @author_blog_ids = split(/:/, $commenter_id) or return $app->errtrans("Permission denied.");
	my $author_id = @author_blog_ids[0] or return $app->errtrans("Permission denied.");

	# load blog
	require MT::Blog;
	my $blog = MT::Blog->load($blog_id);

	# load author
	require MT::Author;
	my $author = MT::Author->load({ id => $author_id });
	my $type = $app->param('_type') || 'entry';
	$app->{author} = $author;
	if(!$app->is_authorized){
		return $app->errtrans("Permission denied.");
	}
}

1;