package MT::Plugin::RegexReplace;

use strict;
use MT::Template::Context;
use base qw(MT::Plugin);

my $plugin = new MT::Plugin::RegexReplace({
    name        => 'RegexReplace',
    version     => '0.01',
    description => 'Expand The \'regex_replace\' global modifire tag.',
    author_name => 'bzbell',

    registry => {
        tags => {
            modifier => {
                regex_replace => \&regex_replace_main,
            },
        },
    },
});

MT->add_plugin($plugin);

sub instance
{
    $plugin;
}

sub regex_replace_main
{
    my ($str, $val, $ctx) = @_;

    return $str unless ref($val) eq 'ARRAY';

    my $patt    = $val->[0];
    my $replace = $val->[1];

    if ($patt !~ m/^\//) {
        $patt =~ s/\//\\\//g;
        $patt = '/' . $patt . '/';
    }

    if ($patt =~ m!^(/)(.+)\1([A-Za-z]+)?$!) {
        $patt = $2;
        my $global;

        if (my $opt = $3) {
            $global = 1 if $opt =~ m/g/;
            $opt =~ s/[ge]+//g;
            $patt = "(?$opt)" . $patt;
        }

        my $re = eval { qr/$patt/ };

        if (defined $re) {
            $replace =~ s!\\\\(\d+)!\$$1!g; # for php, \\1 is how you write $1

            if ($global) {
                $str =~ s/$re/$replace/g;
                my @matches = ($0, $1, $2, $3, $4, $5, $6, $7, $8, $9, $10, $11, $12, $13, $14, $15, $16, $17, $18, $19, $20);
                $str =~ s/\$(\d+)/$matches[$1]/g;
            }
            else {
                $str =~ s/$re/$replace/;
                my @matches = ($0, $1, $2, $3, $4, $5, $6, $7, $8, $9, $10, $11, $12, $13, $14, $15, $16, $17, $18, $19, $20);
                $str =~ s/\$(\d+)/$matches[$1]/g;
            }
        }
    }

    $str;
}

1;
