package FeedEx::Plugin;

use strict;

use MT;
use MT::Template::Context;
use MT::I18N qw(encode_text);
#use Time::Local qw( timegm );
use MT::Util qw{ format_ts iso2ts encode_html remove_html decode_html };

use constant FEED => 'MT::Plugin::FeedEx';
use constant ITEM => 'MT::Plugin::FeedEx::item';

sub sanitize_link {
	my $link = shift;
	$link = '' unless defined $link;
	$link =~ s/^\s+//;
	# check for malicious protocols
	my $dec_val = decode_html($link);
	$dec_val =~ s/&#0*58(?:=;|[^0-9])/:/;
	$dec_val =~ s/&#x0*3[Aa](?:=;|[^a-fA-F0-9])/:/;

	if ((my $prot) = $dec_val =~ m/^(.+?):/) {
		return "#" if $prot =~ m/[\r\n\t]/;
		$prot =~ s/\s+//gs;
		return "#" if $prot =~ m/[^a-zA-Z0-9\+]/;
		return "#" if $prot =~ m/script$/i;
	}

	return "#" unless $link =~ m/^https?:/i;
	$link;
}

sub tag_feed
{
    my ($ctx, $args, $cond) = @_;
    my $uri = $args->{uri};

    if ($uri) {
		require XML::FeedPP;

		my $feed = XML::FeedPP->new($uri)
#					or return $ctx->error("Invalid feed source [$uri]");
					or return '';
		$feed->normalize();
		$ctx->stash(FEED, $feed);

		my $builder = $ctx->stash('builder');
		my $tokens  = $ctx->stash('tokens');
		my $out     = $builder->build($ctx, $tokens, $cond)
						or return $ctx->error($builder->errstr);
		$ctx->stash(FEED, undef);
		$out;
	}
	else {
		return $ctx->error("$uri is a required argument of MTFeedEx");
	}
}

sub tag_feed_title
{
	my ($ctx, $args) = @_;
	my $feed = $ctx->stash(FEED)
				or return _error($ctx);

	my $title = $feed->title();
	$title    = '' unless defined $title;

	my $enc = MT->config->PublishCharset;
	$title  = encode_text(MT::I18N::utf8_off(MT::I18N::decode_utf8($title)), 'utf-8', $enc);
	$title  = remove_html($title)
				unless (exists $args->{remove_html}) && !$args->{remove_html};
	$title  = encode_html($title)
				unless (exists $args->{encode_html}) && !$args->{encode_html};

	delete $args->{encode_html} if exists $args->{encode_html};
	delete $args->{remove_html} if exists $args->{remove_html};
	$title;
}

sub tag_feed_link
{
	my $ctx  = shift;
	my $feed = $ctx->stash(FEED)
				or return _error($ctx);

	my $link = $feed->link();
	my $enc  = MT->config->PublishCharset;
	$link    = encode_text(MT::I18N::utf8_off(MT::I18N::decode_utf8($link)), 'utf-8', $enc);
	sanitize_link($link);
}

sub tag_feed_entries
{
	my ($ctx, $args, $cond) = @_;
	my $feed = $ctx->stash(FEED)
				or return _error($ctx);
	$feed->sort_item();

	my $offset  = $args->{offset} || 0;
	my $last    = $args->{lastn};
	my $builder = $ctx->stash('builder');
	my $tokens  = $ctx->stash('tokens');
	my $html    = '';
	$feed->limit_item($last);

	foreach my $item ($feed->get_item()) {
		$ctx->stash(ITEM, $item);
		my $out = $builder->build($ctx, $tokens, $cond)
					or return $ctx->error($builder->errstr);
		$html .= $out;
	}

	$ctx->stash(ITEM, undef);
	$html;
}

sub tag_feed_entry_title
{
	my ($ctx, $args, $cond) = @_;
	my $item  = $ctx->stash(ITEM)
				or return _error($ctx);
	my $title = $item->title();
	my $enc = MT->config->PublishCharset;
	$title = encode_text(MT::I18N::utf8_off(MT::I18N::decode_utf8($title)), 'utf-8', $enc);
	$title = '' unless defined $title;
	$title = remove_html($title)
			unless (exists $args->{remove_html}) && !$args->{remove_html};
	$title = encode_html($title)
			unless (exists $args->{encode_html}) && !$args->{encode_html};
	delete $args->{encode_html} if exists $args->{encode_html};
	delete $args->{remove_html} if exists $args->{remove_html};
	$title;
}

sub tag_feed_entry_link
{
	my $ctx  = shift;
	my $item = $ctx->stash(ITEM)
				or return _error($ctx);
	my $link = $item->link();
	my $enc  = MT->config->PublishCharset;
	$link    = encode_text(MT::I18N::utf8_off(MT::I18N::decode_utf8($link)), 'utf-8', $enc);
	sanitize_link($link);
}

sub tag_feed_entry_date
{
	my ($ctx, $args, $cond) = @_;
	my $item = $ctx->stash(ITEM)
				or return _error($ctx);
	my $date = iso2ts($ctx->{blog}, $item->pubDate());
	my ($handler) = $ctx->handler_for('ArchiveDate');

	if (defined($handler)) {
		$args->{ts} = $date;
		$date       = $handler->($ctx, $args);
	}
	else {
		$date = format_ts($args->{format}, $date, $ctx->{blog});
	}

	$date;
}

sub tag_feed_entry_desc
{
	my $ctx  = shift;
	my $item = $ctx->stash(ITEM)
				or return _error($ctx);
	my $desc = $item->description();
	my $enc  = MT->config->PublishCharset;
	$desc    = encode_text(MT::I18N::utf8_off($desc), 'utf-8', $enc);
	$desc;
}

1;
