package GetDate;

use strict;
use POSIX qw(strftime mktime);
use Time::Local;

sub getdate_today {
    my ($ctx, $args) = @_;
    my $tod = strftime('%Y-%m-%d %H:%M:%S', localtime);
    $tod;
}

sub getdate_make_time {
    my ($ctx, $args) = @_;
	my @dt = split(/-/, strftime('%Y-%m-%d', localtime));
    my ($y, $m, $d) = ($dt[0] - 1900, $dt[1] - 1, $dt[2]);

    if (exists $args->{date}) {
		@dt = split(/-/, $args->{date});
	}

    if (exists $args->{year})  { $y = $dt[0] + $args->{year} - 1900; }
    if (exists $args->{month}) { $m = $dt[1] + $args->{month} - 1; }
    if (exists $args->{day})   { $d = $dt[2] + $args->{day}; }

	my $tm = timelocal(0, 0, 0, $d, $m, $y);
	my ($day, $month, $year) = (localtime($tm))[3..5];
	return sprintf("%04d-%02d-%02d", $year + 1900, $month + 1, $day);
}

sub getdate_check_date {
    my ($ctx, $args, $cond) = @_;
	my @mlast = (31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
	my @dt = split(/-/, strftime('%Y-%m-%d', localtime));

    if (exists $args->{date}) {
		@dt = split(/-/, $args->{date});
	}
	else {
	    if (exists $args->{year})  { $dt[0] = $args->{year}; }
	    if (exists $args->{month}) { $dt[1] = $args->{month}; }
	    if (exists $args->{day})   { $dt[2] = $args->{day}; }

		if (1 > $dt[1] || 12 < $dt[1]) { return 0; }
	}

	if (2 == $dt[1]) {
		if (((0 == $dt[0] % 4) && (0 != $dt[0] % 100)) || (0 == $dt[0] % 400)) {
			$mlast[1]++;
		}
	}

	if (1 > $dt[2] || $mlast[$dt[1] - 1] < $dt[2]) { return 0; }

	return 1;
}

sub getdate_is_later {
    my ($ctx, $args, $cond) = @_;
	my $now = strftime('%Y-%m-%d', localtime);
	my @dt = split(/-/, $now);

    if (exists $args->{date}) {
		@dt = split(/-/, $args->{date});
	}
	else {
	    if (exists $args->{year})  { $dt[0] = $args->{year}; }
	    if (exists $args->{month}) { $dt[1] = $args->{month}; }
	    if (exists $args->{day})   { $dt[2] = $args->{day}; }
	}

	my $later = sprintf('%04d-%02d-%02d', $dt[0], $dt[1], $dt[2]);
	return !($now > $later);
}

1;
