package GetDate;

use strict;
use POSIX qw(strftime mktime);
use Time::Local;

sub getdate_today {
	my ($ctx, $args) = @_;
	$args->{ts} = strftime('%Y%m%d%H%M%S', localtime);
	return $ctx->build_date($args);
}

sub getdate_make_time {
	my ($ctx, $args) = @_;
	my @dt = split(/-/, strftime('%Y-%m-%d', localtime));

	if (exists $args->{date}) {
		@dt = split(/-/, $args->{date});
	}

	my ($y, $m, $d) = ($dt[0] - 1900, $dt[1] - 1, $dt[2]);

	if (exists $args->{year})  { $y = $args->{year} - 1900; }
	if (exists $args->{month}) { $m = $args->{month} - 1; }
	if (exists $args->{day})   { $d = $args->{day}; }

	my $tm = timelocal(0, 0, 0, $d, $m, $y);

	if (exists $args->{pass}) {
		my $pass = 60 * 60 * 24 * $args->{pass};
		($d, $m, $y) = (localtime($tm + $pass))[3..5];
	}
	else {
		($d, $m, $y) = (localtime($tm))[3..5];
	}

	my @tim = split(/:/, strftime('%H:%M:%S', localtime));
	$args->{ts} = sprintf("%04d%02d%02d%02d%02d%02d", $y + 1900, $m + 1, $d, $tim[0], $tim[1], $tim[2]);
	return $ctx->build_date($args);
}

sub getdate_check_date {
	my ($ctx, $args, $cond) = @_;
	my @mlast = (31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
	my @dt = split(/-/, strftime('%Y-%m-%d', localtime));

	if (exists $args->{date}) {
		@dt = split(/-/, $args->{date});
	}
	else {
		if (exists $args->{year})  { $dt[0] = $args->{year}; }
		if (exists $args->{month}) { $dt[1] = $args->{month}; }
		if (exists $args->{day})   { $dt[2] = $args->{day}; }

		if (1 > $dt[1] || 12 < $dt[1]) { return 0; }
	}

	if (2 == $dt[1]) {
		if (((0 == $dt[0] % 4) && (0 != $dt[0] % 100)) || (0 == $dt[0] % 400)) {
			$mlast[1]++;
		}
	}

	if (1 > $dt[2] || $mlast[$dt[1] - 1] < $dt[2]) { return 0; }

	return 1;
}

sub getdate_is_later {
	my ($ctx, $args, $cond) = @_;
	my $now = strftime('%Y-%m-%d', localtime);
	my @dt  = split(/-/, $now);

	$now = sprintf('%04d%02d%02d', $dt[0], $dt[1], $dt[2]);

	if (exists $args->{pass}) {
		$args->{format} = "%Y-%m-%d";
		@dt             = split(/-/, getdate_make_time($ctx, $args));
	}
	else {
		if (exists $args->{date}) {
			@dt  = split(/-/, $args->{date});
			$now = sprintf('%04d%02d%02d', $dt[0], $dt[1], $dt[2]);
		}

		if (exists $args->{year})  { $dt[0] = $args->{year}; }
		if (exists $args->{month}) { $dt[1] = $args->{month}; }
		if (exists $args->{day})   { $dt[2] = $args->{day}; }
	}

	my $later = sprintf('%04d%02d%02d', $dt[0], $dt[1], $dt[2]);
	return !($now > $later);
}

1;
