package MT::Plugin::GetDate;

use strict;
use MT::Template::Context;
use base qw(MT::Plugin);

my $plugin = __PACKAGE__->new(
     id         => 'get_date',
    name        => 'GetDate',
    version     => '1.06',
    description => 'A utility for handling date/time.',
    author_name => 'bzbell',
    author_link => 'http://bizcaz.com/',
    doc_link    => 'http://bizcaz.com/archives/2009/04/11-044731.php',
);
MT->add_plugin($plugin);

sub instance{ $plugin; }
sub init_registry {
    my $plugin   = shift;
    my $core_pkg = 'GetDate::';

    $plugin->registry({
        tags => {
            block => {
                'CheckDate?' => $core_pkg . 'getdate_check_date',
                'IsLater?' => $core_pkg . 'getdate_is_later',
            },
            function => {
                Today => $core_pkg . 'getdate_today',
                MakeTime => $core_pkg . 'getdate_make_time',
            },
        },
    });
}

1;
