#include <stdio.h>
#include <malloc.h>

#include "fasta_util.h"

void fasta_write(char *file_name, SeqEntryArray *array, int max_seq_width){
  if(file_name == NULL){
    fprintf(stderr, "fasta_write() : file_name = NULL\n");
    return;
  }

  if(array == NULL){
    fprintf(stderr, "fasta_write() : array = NULL\n");
    return;
  }

  FILE *fp;
  if((fp = fopen(file_name, "w")) == NULL){
    fprintf(stderr, "file open fault : %s\n", file_name);
    return;
  }

  int i, j;
  for(i=0; i<array->n; i++){
    SeqEntry *se = (array->array)[i];
    fprintf(fp, ">%s", se->id);
    
    for(j=0; j<se->length; j++){
      if(j%max_seq_width == 0) fprintf(fp, "\n");
      fputc((se->seq)[j], fp);
    }
    fprintf(fp, "\n");
  }  
}

SeqEntryArray *fasta_read(char *file_name){
  FILE *fp;

  char *seq_buf;
  int seq_buf_length = 0;
  int seq_idx;

  char *id_buf;
  int id_buf_length = 0;
  int id_idx = 0;

  int id_num = 0;
  
  unsigned int total_length = 0;
  unsigned int total_seq_num = 0;

  SeqEntryArray *s_array = makeSeqEntryArray(0);
  if(s_array == NULL) return NULL;
  //printf("%d\n", s_array->n);

  if((fp = fopen(file_name, "r")) == NULL){
    fprintf(stderr, "file open fault : %s\n", file_name);
    return NULL;
  }

  seq_buf_length = 256;
  seq_buf = (char*)malloc( sizeof(char) * seq_buf_length );
  if(seq_buf == NULL){
    fprintf(stderr, "memory allocate error\n");
    return NULL;
  }
  
  id_buf_length = 256;
  id_buf = (char*)malloc( sizeof(char) * id_buf_length );
  if(id_buf == NULL){
    fprintf(stderr, "memory allocate error\n");
    return NULL;
  }
  
  fgetc(fp);

  while(!feof(fp)){
    
    id_idx = 0;
    while(1){
      char c = fgetc(fp);

      if(c != '\n'){
	if(id_idx >= id_buf_length){
	  id_buf_length *= 2;
	  id_buf = (char*) realloc(id_buf, sizeof(char) * id_buf_length);
	}
	*(id_buf + id_idx) = c;
	id_idx++;
      }else{
	if(id_idx >= id_buf_length){
	  id_buf_length *= 2;
	  id_buf = (char*) realloc(id_buf, sizeof(char) * id_buf_length);
	}
	*(id_buf + id_idx) = '\0';
	break;
      }
    }
    
    seq_idx = 0;
    while(1){
      char c = fgetc(fp);

      if((c == '>') || feof(fp)){
	if(seq_idx >= seq_buf_length){
	  seq_buf_length *= 2;
	  seq_buf = (char*)realloc(seq_buf, sizeof(char) * seq_buf_length);
	}
	*(seq_buf+seq_idx) = '\0';
	//seq_idx++;
	//printf("%d\t%s\n", idx, seq_buf);
	setSeqEntryArray(s_array, makeSeqEntry(id_buf, id_num, seq_buf, id_idx, seq_idx));
	id_num++;
	
	total_length+= seq_idx;
	total_seq_num++;
	
	break;
      }
      
      if(c != '\n'){
	if(seq_idx >= seq_buf_length){
	  seq_buf_length *= 2;
	  seq_buf = (char*)realloc(seq_buf, sizeof(char) * seq_buf_length);
	}
	*(seq_buf+seq_idx) = c;
	seq_idx++;
      }
    }
  }
    
  //printf("SeqEntryArray num : %d\n", s_array->n);
  //printf("total_length: %d, average length: %lf\n", total_length, ((double)total_length)/total_seq_num);

  return s_array;
}
  

