#ifndef MATRIX_H
#define MATRIX_H

typedef short MATRIX_ELEMENT;

typedef struct _amino_matrix{
  MATRIX_ELEMENT *data;
  int size;
  int *column_index;
  int *row_index;
} AminoMatrix;

AminoMatrix *readMatrixFromFile(char *file_path, void *(* mem_allocate_func)(size_t size));

int getMatrixValue(AminoMatrix *matrix, char c1, char c2);
int getLabelIndex(char c);
int *makeColumnLabelIndex(char *buf, int index_size, void *(* mem_allocate_func)(size_t size));
void makeRowLabelIndexAndMatrix(char *buf, int index_size, MATRIX_ELEMENT *matrix, int *row_index, int row);

#endif
