#ifndef SEQ_BLOCK_READ_H
#define SEQ_BLOCK_READ_H

#include "seq_entry_array.h"

typedef struct _seq_block{
  int n_block;
  int size;
  int *block_idx;
  char *seq_block;
  int alignment;
  int seq_per_block;
  char padding;
}SeqBlock;

SeqBlock *getSeqBlock(SeqEntryArray *array,
		      int alignment, int seq_per_block, char padding,
		      void *(* mem_allocate_func)(size_t size));

int copyBlock(SeqEntryArray *array, int alignment ,int seq_per_block, int block_top_idx, char *block);

int getBlockSize(SeqBlock *block);
int getBlockCount(SeqBlock *block);
char *getBlockSeq(SeqBlock *block, int idx);
int getSeqBlockSeqLengthAlignmented(SeqBlock *block, int idx);
void copySeqBlockSeqAlignmented(SeqBlock *block, int idx, char *dst);

int cmpSeqBlockAndSeqEntry(SeqBlock *block, SeqEntryArray *array, int idx);

char *getAlignedSeq(char *seq, int len, int alignment, char padding);

#endif
