#include <stdio.h>
#include <string.h>
#include <malloc.h>

#include "seq_entry_array.h"

SeqEntryArray *makeSeqEntryArray(int size){
  if(size <= 0) size = SEQ_ENTRY_ARRAY_INIT_LENGTH;

  SeqEntryArray *array = (SeqEntryArray*) malloc (sizeof(SeqEntryArray));
  
  if(array == NULL) return NULL;
  
  array->length = size;
  array->n = 0;
  array->array = (SeqEntry**) calloc (array->length, sizeof(SeqEntry*));

  if(array->array == NULL){
    free(array);
    return NULL;
  }
  
  return array;
}

int initSeqEntryArray(SeqEntryArray *array){
  array->length = SEQ_ENTRY_ARRAY_INIT_LENGTH;
  array->n = 0;
  array->array = (SeqEntry**) calloc (array->length, sizeof(SeqEntry*));
  
  if(array->array == NULL) return 1;
  
  return 0;
}

SeqEntry *getSeqEntryArray(SeqEntryArray *array, int index){
  if(array == NULL) return NULL;
  if(index >= array->n) return NULL;

  return (array->array)[index];
}

int setSeqEntryArray(SeqEntryArray *array, SeqEntry *entry){
  if(array == NULL) return -1;
  
  if(array->n >= array->length){
    array->length *= 2;
    array->array = (SeqEntry**) realloc(array->array, sizeof(SeqEntry*) * array->length);
    memset(array->array + array->n, 0, (array->length) /2);
  }

  (array->array)[array->n] = entry;
  return ++(array->n);
}

SeqEntry *makeSeqEntry(char *id, int id_num, char *seq, int id_length, int seq_length){
  SeqEntry *s_entry = (SeqEntry*) malloc (sizeof(SeqEntry));
  
  if(s_entry == NULL) return NULL;

  if(id_length < 0) id_length = strlen(id);
  if(seq_length < 0) seq_length = strlen(seq);

  s_entry->id = (char*) malloc (sizeof(char) * (id_length+1) );
  if(s_entry->id == NULL){
    free(s_entry);
    return NULL;
  }

  s_entry->id_num = id_num;

  s_entry->seq = (char*) malloc (sizeof(char) * (seq_length+1) );
  if(s_entry->seq == NULL){
    free(s_entry);
    return NULL;
  }

  memmove(s_entry->id, id, id_length+1);
  memmove(s_entry->seq, seq, seq_length+1);
  s_entry->length = seq_length;
  
  return s_entry;
}

int cmpEntryByLength(const void *entry1, const void *entry2){
  SeqEntry *e1, *e2;
  e1 = *((SeqEntry**)entry1);
  e2 = *((SeqEntry**)entry2);

  if(e1->length > e2->length) return 1;
  if(e1->length < e2->length) return -1;
  return 0;
}

void paddingSeqEntry(SeqEntry *seq, int head, int alignment, int tail, char pad){
  int l = (seq->length + alignment - 1)/alignment;
  l = l * alignment + head + tail;

  char *buf = (char*)malloc(sizeof(char)*(l + 1));

  seq->seq = (char*)realloc(seq->seq, sizeof(char) * l);
  memmove(buf + head, seq->seq, seq->length);
  memset(buf, pad, head);
  memset(buf + head + seq->length, pad, l - head - seq->length);
  buf[l+1] = '\0';

  free(seq->seq);
  seq->seq = buf;

  seq->length = l;
}
