#ifndef SEQENTRYARRAY_H
#define SEQENTRYARRAY_H

#define SEQ_ENTRY_ARRAY_INIT_LENGTH 128

typedef struct _seq_entry{
  char *id;
  int id_num;
  char *seq;
  int length;
} SeqEntry;

typedef struct _seq_entry_array{
  SeqEntry **array;
  int n;
  int length;
} SeqEntryArray;

SeqEntryArray *makeSeqEntryArray(int size);
int initSeqEntryArray(SeqEntryArray *array);
SeqEntry *getSeqEntryArray(SeqEntryArray *array, int index);
int setSeqEntryArray(SeqEntryArray *array, SeqEntry *entry);
SeqEntry *makeSeqEntry(char *id, int id_num,char *seq, int id_length, int seq_length);

void paddingSeqEntry(SeqEntry *seq, int head, int alignment, int tail, char pad);

int cmpEntryByLength(const void *entry1, const void *entry2);


#endif
