#ifndef SW_CUDA_H
#define SW_CUDA_H

#include <omp.h>
#include <cutil_inline.h>

extern "C"{
#include "seq_block_read.h"
#include "matrix.h"
#include "sw_cuda_param.h"
#include "sw_cuda_c.h"
}

typedef short2 TempScore;

////////////////////////////////////////////////////////////////////
template <int BLOCK_DIM_X, int BLOCK_DIM_Y>
  __global__
  void kernelSmithWaterman(char *seq_data,
			   int *seq_index,
			   char* query_seq,
			   int query_len,
			   TempScore *g_temp_H,
			   int *g_result);

__global__
void kernelScoreIndex(char *seq_block, char *index_block, 
		      int *amino_index, char padding,
		      int n_block_total);

// This is a test function
__global__
void kernelScoreMatrixTextureTest(MATRIX_ELEMENT *result);

#endif
