#ifndef SW_CUDA_C_H
#define SW_CUDA_C_H

#include "seq_block_read.h"
#include "matrix.h"

typedef struct _sw_result{
  //  char *id;
  int index;
  int score;
} SWResult;

typedef struct _processors{
  int n_proc;
  int n_gpu;
  int n_cpu;
}Processors;

typedef struct _task_plan{
  Processors *proc;
  
  //  SeqEntryArray **s_array;
  //SeqBlock **s_block;
  AminoMatrix *a_matrix;

  // $B%G!<%?%Y!<%9%7!<%1%s%9(B
  char *h_seq_data;
  char *d_seq_data;
  
  // $B%G!<%?%Y!<%9%7!<%1%s%9$N%$%s%G%C%/%9(B
  int *h_seq_data_index;
  int *d_seq_data_index;

  // $B%G!<%?%Y!<%9%7!<%1%s%9$N(BID
  int *h_seq_id_index;
  
  // $B%G!<%?%Y!<%9%7!<%1%s%9?t(B
  int n_seq;
  
  // $B%G!<%?%Y!<%9$N%"%_%N;@?t(B
  int n_cell;

  int n_padded_cell;
  
  // $B3F%Z%J%k%F%#!<(B
  int gap_open;
  int gap_extend;
} TaskPlan;

typedef struct _proc_seq_array{
  SeqEntryArray *s_array;
  int total_len;
  int proc_num;
}ProcSeqArray;

extern
TaskPlan *makeTaskPlan(Processors *proc,
		       char *seq_file_prefix,
		       AminoMatrix *amino_mat,
		       int gap_open,
		       int gap_extend);

extern
SWResult *getSWResult(char *d_seq_data,
		      int *d_seq_data_index,
		      int n_seq,
		      char *d_query_seq,
		      int query_len,
		      int block_per_kernel_call,
		      int thread_per_block,
		      int warp_size, 
		      int *h_seq_id_index,
		      int num_answer);

extern
SWResult *getSWResultWithMultiThreads(TaskPlan *tp,
				      Processors *proc,
				      char *h_indexed_qseq, int indexed_qseq_len,
				      int block_per_kernel_call, int thread_per_block, int warp_size,
				      int num_answer);

extern char *makeScoreIndexBlock(SeqBlock *h_block, AminoMatrix *h_matrix, char padding);
extern int *makeSequenceIndex(SeqBlock *h_block);
extern int cmpProcSeqArray(const void *a, const void *b);
extern int cmpSWResult(const void *a, const void *b);
extern int getIndexedSeq(char *h_dst, char *h_src, int seq_len, int *h_index, char padding);
extern int makePaddedQueryIndexSeq(char **d_seq, char *h_index_qseq, int qseq_len,char padding_index, int head_padding_size, int tail_padding_size, int alignment);
extern void *cudaHostAllocPinned(size_t size);
extern void setGap(int *open, int *extend);
extern void setScoreMatrixToTexture(AminoMatrix *h_matrix);
extern void setSubjectSeqsToTexture(char *d_score_index_block, int size);
extern void textureCheck(AminoMatrix *h_matrix);
extern Processors *getProcessors(int n_gpu_limit);

//extern void divideSeqEntryArray(SeqEntryArray *src_array, TaskPlan *tp);

extern
int readKFasta(char *path,
	       char **seq_data,
	       int **seq_data_index,
	       int **seq_id_index,
	       int *n_seq,
	       int *n_cell,
	       int *n_padded_cell);
#endif
