/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.commit;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.commit.CommitBuilder;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.ArgumentxRequest;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.DirectoryRequest;
import org.netbeans.lib.cvsclient.request.EntryRequest;
import org.netbeans.lib.cvsclient.request.Request;
import org.netbeans.lib.cvsclient.request.StickyRequest;

public class CommitCommand
extends BasicCommand {
    private final List argumentRequests = new LinkedList();
    private String message;
    private boolean forceCommit;
    private String logMessageFromFile;
    private boolean noModuleProgram;
    private String toRevisionOrBranch;

    public CommitCommand() {
        this.resetCVSCommand();
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public boolean isForceCommit() {
        return this.forceCommit;
    }

    public void setForceCommit(boolean bl) {
        this.forceCommit = bl;
    }

    protected void addRequestsForDirectory(File file) throws IOException {
        Object object;
        Object object2;
        File[] fileArray;
        Object object3;
        if (!file.exists()) {
            return;
        }
        String string = this.getRelativeToLocalPathInUnixStyle(file);
        try {
            object3 = this.clientServices.getRepositoryForDirectory(file.getAbsolutePath());
            this.requests.add(new DirectoryRequest(string, (String)object3));
            fileArray = this.clientServices.getStickyTagForDirectory(file);
            if (fileArray != null) {
                this.requests.add(new StickyRequest((String)fileArray));
            }
        }
        catch (IOException iOException) {
            System.err.println("An error occurred reading the respository for the directory " + string + ": " + iOException);
            iOException.printStackTrace();
        }
        object3 = this.clientServices.getAllFiles(file);
        fileArray = file.listFiles();
        object3.addAll(Arrays.asList(fileArray));
        LinkedList<Object> linkedList = null;
        if (this.isRecursive()) {
            linkedList = new LinkedList<Object>();
        }
        Iterator iterator = object3.iterator();
        while (iterator.hasNext()) {
            object2 = (File)iterator.next();
            if (((File)object2).isHidden() || ((File)object2).getName().equals("CVS")) continue;
            try {
                File file2;
                object = this.clientServices.getEntry((File)object2);
                if (object == null) continue;
                if (!((File)object2).isDirectory()) {
                    this.sendEntryAndModifiedRequests((Entry)object, (File)object2);
                    continue;
                }
                if (!this.isRecursive() || !((File)object2).isDirectory() || !(file2 = new File((File)object2, "CVS")).exists()) continue;
                linkedList.add(object2);
            }
            catch (IOException iOException) {
                System.err.println("An error occurred getting the Entry for file " + object2 + ": " + iOException);
                iOException.printStackTrace();
            }
        }
        if (this.isRecursive()) {
            object2 = linkedList.iterator();
            while (object2.hasNext()) {
                object = (File)object2.next();
                this.addRequestsForDirectory((File)object);
            }
        }
    }

    protected void addRequestsForFile(File file) throws IOException {
        Object object;
        File file2 = file.getParentFile();
        String string = this.getRelativeToLocalPathInUnixStyle(file2);
        try {
            this.requests.add(new DirectoryRequest(string, this.clientServices.getRepositoryForDirectory(file2.getAbsolutePath())));
            object = this.clientServices.getStickyTagForDirectory(file2);
            if (object != null) {
                this.requests.add(new StickyRequest((String)object));
            }
        }
        catch (IOException iOException) {
            System.err.println("An error occurred reading the respository for the directory " + string + ": " + iOException);
            iOException.printStackTrace();
        }
        try {
            object = this.clientServices.getEntry(file);
            if (object != null) {
                this.sendEntryAndModifiedRequests((Entry)object, file);
            }
        }
        catch (IOException iOException) {
            System.err.println("An error occurred getting the Entry for file " + file + ": " + iOException);
            iOException.printStackTrace();
        }
    }

    protected boolean doesCheckFileTime() {
        return !this.isForceCommit();
    }

    public void execute(ClientServices clientServices, EventManager eventManager) throws CommandException, AuthenticationException {
        clientServices.ensureConnection();
        super.execute(clientServices, eventManager);
        try {
            try {
                if (this.isForceCommit()) {
                    this.requests.add(1, new ArgumentRequest("-f"));
                    if (this.isRecursive()) {
                        this.requests.add(1, new ArgumentRequest("-R"));
                    }
                }
                if (this.isNoModuleProgram()) {
                    this.requests.add(1, new ArgumentRequest("-n"));
                }
                if (this.getToRevisionOrBranch() != null) {
                    this.requests.add(1, new ArgumentRequest("-r"));
                    this.requests.add(2, new ArgumentRequest(this.getToRevisionOrBranch()));
                }
                String string = this.getMessage();
                if (this.getLogMessageFromFile() != null) {
                    string = this.loadLogFile(this.getLogMessageFromFile());
                }
                if (string != null) {
                    string = string.trim();
                }
                if (string == null || string.length() == 0) {
                    string = "no message";
                }
                this.addMessageRequest(string);
                this.addRequestForWorkingDirectory(clientServices);
                this.requests.addAll(this.argumentRequests);
                this.argumentRequests.clear();
                this.addArgumentRequests();
                this.requests.add(CommandRequest.COMMIT);
                clientServices.processRequests(this.requests);
            }
            catch (CommandException commandException) {
                throw commandException;
            }
            catch (Exception exception) {
                throw new CommandException(exception, exception.getLocalizedMessage());
            }
            Object var6_5 = null;
            this.requests.clear();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.requests.clear();
            throw throwable;
        }
    }

    protected void addArgumentRequests() {
        if (this.isForceCommit()) {
            Iterator iterator = this.requests.iterator();
            String string = "";
            LinkedList<ArgumentRequest> linkedList = new LinkedList<ArgumentRequest>();
            while (iterator.hasNext()) {
                Request request;
                Object e = iterator.next();
                if (e instanceof DirectoryRequest) {
                    request = (DirectoryRequest)e;
                    string = ((DirectoryRequest)request).getLocalDirectory();
                    continue;
                }
                if (!(e instanceof EntryRequest)) continue;
                request = (EntryRequest)e;
                String string2 = null;
                string2 = string.length() == 0 ? ((EntryRequest)request).getEntry().getName() : string + '/' + ((EntryRequest)request).getEntry().getName();
                linkedList.add(new ArgumentRequest(string2));
            }
            iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                this.requests.add(iterator.next());
            }
        } else {
            super.addArgumentRequests();
        }
    }

    public String getCVSCommand() {
        StringBuffer stringBuffer = new StringBuffer("commit ");
        stringBuffer.append(this.getCVSArguments());
        File[] fileArray = this.getFiles();
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                stringBuffer.append(fileArray[n].getName() + " ");
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public boolean setCVSCommand(char c, String string) {
        if (c == 'm') {
            this.setMessage(string);
        } else if (c == 'l') {
            this.setRecursive(false);
        } else if (c == 'R') {
            this.setRecursive(true);
        } else if (c == 'f') {
            this.setForceCommit(true);
        } else if (c == 'F') {
            this.setLogMessageFromFile(string);
        } else if (c == 'r') {
            this.setToRevisionOrBranch(string);
        } else if (c == 'n') {
            this.setNoModuleProgram(true);
        } else {
            return false;
        }
        return true;
    }

    public String getOptString() {
        return "m:flRnF:r:";
    }

    public Builder createBuilder(EventManager eventManager) {
        return new CommitBuilder(eventManager, this.getLocalDirectory());
    }

    private void addMessageRequest(String string) {
        this.requests.add(new ArgumentRequest("-m"));
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", false);
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            if (bl) {
                this.requests.add(new ArgumentRequest(stringTokenizer.nextToken()));
                bl = false;
                continue;
            }
            this.requests.add(new ArgumentxRequest(stringTokenizer.nextToken()));
        }
    }

    public String getLogMessageFromFile() {
        return this.logMessageFromFile;
    }

    public void setLogMessageFromFile(String string) {
        this.logMessageFromFile = string;
    }

    public boolean isNoModuleProgram() {
        return this.noModuleProgram;
    }

    public void setNoModuleProgram(boolean bl) {
        this.noModuleProgram = bl;
    }

    public String getToRevisionOrBranch() {
        return this.toRevisionOrBranch;
    }

    public void setToRevisionOrBranch(String string) {
        this.toRevisionOrBranch = string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadLogFile(String string) throws CommandException {
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = null;
        try {
            try {
                String string2;
                bufferedReader = new BufferedReader(new FileReader(string));
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string2 + "\n");
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new CommandException(fileNotFoundException, CommandException.getLocalMessage("CommitCommand.logInfoFileNotExists", new Object[]{string}));
            }
            catch (IOException iOException) {
                throw new CommandException(iOException, CommandException.getLocalMessage("CommitCommand.errorReadingLogFile", new Object[]{string}));
            }
            Object var7_6 = null;
            if (bufferedReader == null) return stringBuffer.toString();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        bufferedReader.close();
        return stringBuffer.toString();
    }

    public void resetCVSCommand() {
        this.setMessage(null);
        this.setRecursive(true);
        this.setForceCommit(false);
        this.setLogMessageFromFile(null);
        this.setNoModuleProgram(false);
        this.setToRevisionOrBranch(null);
    }

    public String getCVSArguments() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isRecursive()) {
            stringBuffer.append("-l ");
        }
        if (this.isForceCommit()) {
            stringBuffer.append("-f ");
            if (this.isRecursive()) {
                stringBuffer.append("-R ");
            }
        }
        if (this.isNoModuleProgram()) {
            stringBuffer.append("-n ");
        }
        if (this.getToRevisionOrBranch() != null) {
            stringBuffer.append("-r ");
            stringBuffer.append(this.getToRevisionOrBranch() + " ");
        }
        if (this.getLogMessageFromFile() != null) {
            stringBuffer.append("-F ");
            stringBuffer.append(this.getLogMessageFromFile());
            stringBuffer.append(" ");
        }
        if (this.getMessage() != null) {
            stringBuffer.append("-m \"");
            stringBuffer.append(this.getMessage());
            stringBuffer.append("\" ");
        }
        return stringBuffer.toString();
    }
}

