/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.history;

import java.util.LinkedList;
import java.util.List;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.CaseRequest;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.RootRequest;
import org.netbeans.lib.cvsclient.request.UseUnchangedRequest;

public class HistoryCommand
extends Command {
    private final List requests = new LinkedList();
    private EventManager eventManager;
    private boolean forAllUsers;
    private String showBackToRecordContaining;
    private boolean reportCommits;
    private String sinceDate;
    private boolean reportEverything;
    private boolean lastEventOfProject;
    private boolean reportCheckouts;
    private String sinceRevision;
    private boolean reportTags;
    private String sinceTag;
    private boolean forWorkingDirectory;
    private String reportEventType;
    private String timeZone;
    private String[] lastEventForFile;
    private String[] reportOnModule;
    private String[] reportLastEventForModule;
    private String[] forUsers;

    public Builder createBuilder(EventManager eventManager) {
        return null;
    }

    public void execute(ClientServices clientServices, EventManager eventManager) throws CommandException, AuthenticationException {
        clientServices.ensureConnection();
        this.eventManager = eventManager;
        this.requests.clear();
        super.execute(clientServices, eventManager);
        try {
            try {
                if (clientServices.isFirstCommand()) {
                    this.requests.add(new RootRequest(clientServices.getRepository()));
                    this.requests.add(new CaseRequest());
                    this.requests.add(new UseUnchangedRequest());
                }
                this.addBooleanArgument(this.requests, this.isForAllUsers(), "-a");
                this.addBooleanArgument(this.requests, this.isForWorkingDirectory(), "-w");
                this.addBooleanArgument(this.requests, this.isLastEventOfProject(), "-l");
                this.addBooleanArgument(this.requests, this.isReportCheckouts(), "-o");
                this.addBooleanArgument(this.requests, this.isReportCommits(), "-c");
                this.addBooleanArgument(this.requests, this.isReportEverything(), "-e");
                this.addBooleanArgument(this.requests, this.isReportTags(), "-T");
                this.addStringArgument(this.requests, this.getReportEventType(), "-x");
                this.addStringArgument(this.requests, this.getShowBackToRecordContaining(), "-b");
                this.addStringArgument(this.requests, this.getSinceDate(), "-D");
                this.addStringArgument(this.requests, this.getSinceRevision(), "-r");
                this.addStringArgument(this.requests, this.getSinceTag(), "-t");
                this.addStringArrayArgument(this.requests, this.getForUsers(), "-u");
                this.addStringArrayArgument(this.requests, this.getReportLastEventForModule(), "-n");
                this.addStringArrayArgument(this.requests, this.getReportOnModule(), "-m");
                this.addStringArrayArgument(this.requests, this.getLastEventForFile(), "-f");
                if (!(this.isReportCheckouts() || this.isReportCommits() || this.isReportTags() || this.isReportEverything() || this.getReportEventType() != null || this.getReportOnModule() != null)) {
                    this.addBooleanArgument(this.requests, true, "-c");
                }
                if (this.getTimeZone() != null) {
                    this.addStringArgument(this.requests, this.getTimeZone(), "-z");
                } else {
                    this.addStringArgument(this.requests, "+0000", "-z");
                }
                this.requests.add(CommandRequest.HISTORY);
                clientServices.processRequests(this.requests);
            }
            catch (CommandException commandException) {
                throw commandException;
            }
            catch (Exception exception) {
                throw new CommandException(exception, exception.getLocalizedMessage());
            }
            Object var6_3 = null;
            this.requests.clear();
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            this.requests.clear();
            throw throwable;
        }
    }

    private void addStringArgument(List list, String string, String string2) {
        if (string != null) {
            list.add(new ArgumentRequest(string2));
            list.add(new ArgumentRequest(string));
        }
    }

    private void addStringArrayArgument(List list, String[] stringArray, String string) {
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                list.add(new ArgumentRequest(string));
                list.add(new ArgumentRequest(stringArray[n]));
                ++n;
            }
        }
    }

    private void addBooleanArgument(List list, boolean bl, String string) {
        if (bl) {
            list.add(new ArgumentRequest(string));
        }
    }

    public void commandTerminated(TerminationEvent terminationEvent) {
    }

    public String getCVSCommand() {
        StringBuffer stringBuffer = new StringBuffer("history ");
        stringBuffer.append(this.getCVSArguments());
        return stringBuffer.toString();
    }

    public boolean setCVSCommand(char c, String string) {
        if (c == 'a') {
            this.setForAllUsers(true);
        } else if (c == 'b') {
            this.setShowBackToRecordContaining(string);
        } else if (c == 'c') {
            this.setReportCommits(true);
        } else if (c == 'D') {
            this.setSinceDate(string);
        } else if (c == 'e') {
            this.setReportEverything(true);
        } else if (c == 'l') {
            this.setLastEventOfProject(true);
        } else if (c == 'o') {
            this.setReportCheckouts(true);
        } else if (c == 'r') {
            this.setSinceRevision(string);
        } else if (c == 'T') {
            this.setReportTags(true);
        } else if (c == 't') {
            this.setSinceTag(string);
        } else if (c == 'w') {
            this.setForWorkingDirectory(true);
        } else if (c == 'x') {
            this.setReportEventType(string);
        } else if (c == 'z') {
            this.setTimeZone(string);
        } else if (c == 'f') {
            this.addLastEventForFile(string);
        } else if (c == 'm') {
            this.addReportOnModule(string);
        } else if (c == 'n') {
            this.addReportLastEventForModule(string);
        } else if (c == 'u') {
            this.addForUsers(string);
        } else {
            return false;
        }
        return true;
    }

    public String getOptString() {
        return "ab:cD:ef:lm:n:or:Tt:u:wx:z:";
    }

    public void resetCVSCommand() {
        this.setForAllUsers(false);
        this.setForUsers(null);
        this.setForWorkingDirectory(false);
        this.setLastEventForFile(null);
        this.setLastEventOfProject(false);
        this.setReportCheckouts(false);
        this.setReportCommits(false);
        this.setReportEventType(null);
        this.setReportEverything(false);
        this.setReportLastEventForModule(null);
        this.setReportOnModule(null);
        this.setReportTags(false);
        this.setShowBackToRecordContaining(null);
        this.setSinceDate(null);
        this.setSinceRevision(null);
        this.setSinceTag(null);
        this.setTimeZone(null);
    }

    public String getCVSArguments() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.isForAllUsers()) {
            stringBuffer.append("-a ");
        }
        if (this.isForWorkingDirectory()) {
            stringBuffer.append("-w ");
        }
        if (this.isLastEventOfProject()) {
            stringBuffer.append("-l ");
        }
        if (this.isReportCheckouts()) {
            stringBuffer.append("-o ");
        }
        if (this.isReportCommits()) {
            stringBuffer.append("-c ");
        }
        if (this.isReportEverything()) {
            stringBuffer.append("-e ");
        }
        if (this.isReportTags()) {
            stringBuffer.append("-T ");
        }
        if (this.getForUsers() != null) {
            this.appendArrayToSwitches(stringBuffer, this.getForUsers(), "-u ");
        }
        if (this.getLastEventForFile() != null) {
            this.appendArrayToSwitches(stringBuffer, this.getLastEventForFile(), "-f ");
        }
        if (this.getReportEventType() != null) {
            stringBuffer.append("-x ");
            stringBuffer.append(this.getReportEventType());
            stringBuffer.append(" ");
        }
        if (this.getReportLastEventForModule() != null) {
            this.appendArrayToSwitches(stringBuffer, this.getReportLastEventForModule(), "-n ");
        }
        if (this.getReportOnModule() != null) {
            this.appendArrayToSwitches(stringBuffer, this.getReportOnModule(), "-m ");
        }
        if (this.getShowBackToRecordContaining() != null) {
            stringBuffer.append("-b ");
            stringBuffer.append(this.getShowBackToRecordContaining());
            stringBuffer.append(" ");
        }
        if (this.getSinceDate() != null) {
            stringBuffer.append("-D ");
            stringBuffer.append(this.getSinceDate());
            stringBuffer.append(" ");
        }
        if (this.getSinceRevision() != null) {
            stringBuffer.append("-r ");
            stringBuffer.append(this.getSinceRevision());
            stringBuffer.append(" ");
        }
        if (this.getSinceTag() != null) {
            stringBuffer.append("-t ");
            stringBuffer.append(this.getSinceTag());
            stringBuffer.append(" ");
        }
        if (this.getTimeZone() != null) {
            stringBuffer.append("-z ");
            stringBuffer.append(this.getTimeZone());
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    private void appendArrayToSwitches(StringBuffer stringBuffer, String[] stringArray, String string) {
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(string);
            stringBuffer.append(stringArray[n]);
            stringBuffer.append(" ");
            ++n;
        }
    }

    public boolean isForAllUsers() {
        return this.forAllUsers;
    }

    public void setForAllUsers(boolean bl) {
        this.forAllUsers = bl;
    }

    public String getShowBackToRecordContaining() {
        return this.showBackToRecordContaining;
    }

    public void setShowBackToRecordContaining(String string) {
        this.showBackToRecordContaining = string;
    }

    public boolean isReportCommits() {
        return this.reportCommits;
    }

    public void setReportCommits(boolean bl) {
        this.reportCommits = bl;
    }

    public String getSinceDate() {
        return this.sinceDate;
    }

    public void setSinceDate(String string) {
        this.sinceDate = string;
    }

    public boolean isReportEverything() {
        return this.reportEverything;
    }

    public void setReportEverything(boolean bl) {
        this.reportEverything = bl;
    }

    public boolean isLastEventOfProject() {
        return this.lastEventOfProject;
    }

    public void setLastEventOfProject(boolean bl) {
        this.lastEventOfProject = bl;
    }

    public boolean isReportCheckouts() {
        return this.reportCheckouts;
    }

    public void setReportCheckouts(boolean bl) {
        this.reportCheckouts = bl;
    }

    public String getSinceRevision() {
        return this.sinceRevision;
    }

    public void setSinceRevision(String string) {
        this.sinceRevision = string;
    }

    public boolean isReportTags() {
        return this.reportTags;
    }

    public void setReportTags(boolean bl) {
        this.reportTags = bl;
    }

    public String getSinceTag() {
        return this.sinceTag;
    }

    public void setSinceTag(String string) {
        this.sinceTag = string;
    }

    public boolean isForWorkingDirectory() {
        return this.forWorkingDirectory;
    }

    public void setForWorkingDirectory(boolean bl) {
        this.forWorkingDirectory = bl;
    }

    public String getReportEventType() {
        return this.reportEventType;
    }

    public void setReportEventType(String string) {
        this.reportEventType = string;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String string) {
        this.timeZone = string;
    }

    public String[] getLastEventForFile() {
        return this.lastEventForFile;
    }

    public void setLastEventForFile(String[] stringArray) {
        this.lastEventForFile = stringArray;
    }

    public void addLastEventForFile(String string) {
        this.lastEventForFile = this.addNewValue(this.lastEventForFile, string);
    }

    public String[] getReportOnModule() {
        return this.reportOnModule;
    }

    public void setReportOnModule(String[] stringArray) {
        this.reportOnModule = stringArray;
    }

    public void addReportOnModule(String string) {
        this.reportOnModule = this.addNewValue(this.reportOnModule, string);
    }

    public String[] getReportLastEventForModule() {
        return this.reportLastEventForModule;
    }

    public void setReportLastEventForModule(String[] stringArray) {
        this.reportLastEventForModule = stringArray;
    }

    public void addReportLastEventForModule(String string) {
        this.reportLastEventForModule = this.addNewValue(this.reportLastEventForModule, string);
    }

    public String[] getForUsers() {
        return this.forUsers;
    }

    public void setForUsers(String[] stringArray) {
        this.forUsers = stringArray;
    }

    public void addForUsers(String string) {
        this.forUsers = this.addNewValue(this.forUsers, string);
    }

    private String[] addNewValue(String[] stringArray, String string) {
        if (stringArray == null) {
            stringArray = new String[]{string};
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length + 1];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n] = stringArray[n];
            ++n;
        }
        stringArray2[stringArray2.length] = string;
        return stringArray2;
    }
}

