/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.tag;

import java.io.EOFException;
import java.io.File;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.tag.TagBuilder;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.CommandRequest;

public class TagCommand
extends BasicCommand {
    private EventManager eventManager;
    private boolean checkThatUnmodified;
    private boolean deleteTag;
    private boolean makeBranchTag;
    private boolean overrideExistingTag;
    private String tag;
    private String tagByDate;
    private String tagByRevision;

    public Builder createBuilder(EventManager eventManager) {
        return new TagBuilder(eventManager, this.getLocalDirectory());
    }

    public boolean doesCheckThatUnmodified() {
        return this.checkThatUnmodified;
    }

    public boolean isCheckThatUnmodified() {
        return this.checkThatUnmodified;
    }

    public void setCheckThatUnmodified(boolean bl) {
        this.checkThatUnmodified = bl;
    }

    public boolean doesDeleteTag() {
        return this.deleteTag;
    }

    public boolean isDeleteTag() {
        return this.deleteTag;
    }

    public void setDeleteTag(boolean bl) {
        this.deleteTag = bl;
    }

    public boolean doesMakeBranchTag() {
        return this.makeBranchTag;
    }

    public boolean isMakeBranchTag() {
        return this.makeBranchTag;
    }

    public void setMakeBranchTag(boolean bl) {
        this.makeBranchTag = bl;
    }

    public boolean doesOverrideExistingTag() {
        return this.overrideExistingTag;
    }

    public boolean isOverrideExistingTag() {
        return this.overrideExistingTag;
    }

    public void setOverrideExistingTag(boolean bl) {
        this.overrideExistingTag = bl;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String string) {
        this.tag = string;
    }

    public String getTagByDate() {
        return this.tagByDate;
    }

    public void setTagByDate(String string) {
        this.tagByDate = string;
    }

    public String getTagByRevision() {
        return this.tagByRevision;
    }

    public void setTagByRevision(String string) {
        this.tagByRevision = string;
    }

    public void execute(ClientServices clientServices, EventManager eventManager) throws CommandException, AuthenticationException {
        clientServices.ensureConnection();
        this.eventManager = eventManager;
        super.execute(clientServices, eventManager);
        try {
            try {
                this.requests.add(1, new ArgumentRequest(this.getTag()));
                if (this.checkThatUnmodified) {
                    this.requests.add(1, new ArgumentRequest("-c"));
                }
                if (this.overrideExistingTag) {
                    this.requests.add(1, new ArgumentRequest("-F"));
                }
                if (this.makeBranchTag) {
                    this.requests.add(1, new ArgumentRequest("-b"));
                }
                if (this.deleteTag) {
                    this.requests.add(1, new ArgumentRequest("-d"));
                }
                if (this.tagByDate != null && this.tagByDate.length() > 0) {
                    this.requests.add(1, new ArgumentRequest("-D"));
                    this.requests.add(2, new ArgumentRequest(this.getTagByDate()));
                }
                if (this.tagByRevision != null && this.tagByRevision.length() > 0) {
                    this.requests.add(1, new ArgumentRequest("-r"));
                    this.requests.add(2, new ArgumentRequest(this.getTagByRevision()));
                }
                this.addRequestForWorkingDirectory(clientServices);
                this.addArgumentRequests();
                this.addRequest(CommandRequest.TAG);
                clientServices.processRequests(this.requests);
            }
            catch (CommandException commandException) {
                throw commandException;
            }
            catch (EOFException eOFException) {
                throw new CommandException(eOFException, CommandException.getLocalMessage("CommandException.EndOfFile", null));
            }
            catch (Exception exception) {
                throw new CommandException(exception, exception.getLocalizedMessage());
            }
            Object var7_3 = null;
            this.requests.clear();
        }
        catch (Throwable throwable) {
            Object var7_4 = null;
            this.requests.clear();
            throw throwable;
        }
    }

    public void commandTerminated(TerminationEvent terminationEvent) {
        if (this.builder != null) {
            this.builder.outputDone();
        }
    }

    public String getCVSCommand() {
        File[] fileArray;
        StringBuffer stringBuffer = new StringBuffer("tag ");
        stringBuffer.append(this.getCVSArguments());
        if (this.getTag() != null) {
            stringBuffer.append(this.getTag());
            stringBuffer.append(" ");
        }
        if ((fileArray = this.getFiles()) != null) {
            int n = 0;
            while (n < fileArray.length) {
                stringBuffer.append(fileArray[n].getName());
                stringBuffer.append(' ');
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public boolean setCVSCommand(char c, String string) {
        if (c == 'R') {
            this.setRecursive(true);
        } else if (c == 'l') {
            this.setRecursive(false);
        } else if (c == 'c') {
            this.setCheckThatUnmodified(true);
        } else if (c == 'd') {
            this.setDeleteTag(true);
        } else if (c == 'F') {
            this.setOverrideExistingTag(true);
        } else if (c == 'b') {
            this.setMakeBranchTag(true);
        } else if (c == 'D') {
            this.setTagByDate(string.trim());
        } else if (c == 'r') {
            this.setTagByRevision(string.trim());
        } else {
            return false;
        }
        return true;
    }

    public String getOptString() {
        return "RlcFbdD:r:";
    }

    public void resetCVSCommand() {
        this.setRecursive(true);
        this.setCheckThatUnmodified(false);
        this.setDeleteTag(false);
        this.setMakeBranchTag(false);
        this.setOverrideExistingTag(false);
    }

    public String getCVSArguments() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isRecursive()) {
            stringBuffer.append("-l ");
        }
        if (this.isCheckThatUnmodified()) {
            stringBuffer.append("-c ");
        }
        if (this.isOverrideExistingTag()) {
            stringBuffer.append("-F ");
        }
        if (this.isMakeBranchTag()) {
            stringBuffer.append("-b ");
        }
        if (this.isDeleteTag()) {
            stringBuffer.append("-d ");
        }
        if (this.getTagByRevision() != null && this.getTagByRevision().length() > 0) {
            stringBuffer.append("-r ");
            stringBuffer.append(this.getTagByRevision());
            stringBuffer.append(" ");
        }
        if (this.getTagByDate() != null && this.getTagByDate().length() > 0) {
            stringBuffer.append("-D ");
            stringBuffer.append(this.getTagByDate());
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }
}

