/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.imptool;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.java.imptool.ImpDataSource;
import org.netbeans.modules.java.imptool.SourceIdentifier;
import org.openide.src.SourceException;

class SourceIdentifiersList {
    private List sourceIdentifiers = new ArrayList();
    private ImpDataSource datasource;
    private PropertyChangeSupport propSupport;
    static final String PROP_FQN_FLAG = "FQN_FLAG";

    SourceIdentifiersList(ImpDataSource impDataSource) {
        this.datasource = impDataSource;
    }

    boolean addSourceIdentifier(SourceIdentifier sourceIdentifier) {
        return this.sourceIdentifiers.add(sourceIdentifier);
    }

    boolean removeSourceIdentifier(SourceIdentifier sourceIdentifier) {
        return this.sourceIdentifiers.remove(sourceIdentifier);
    }

    int getFQNFlag() {
        Iterator iterator = this.sourceIdentifiers.iterator();
        if (iterator.hasNext()) {
            SourceIdentifier sourceIdentifier = (SourceIdentifier)iterator.next();
            return sourceIdentifier.getUseFQN();
        }
        return 0;
    }

    void setFQNFlag(int n) {
        Object object;
        Iterator iterator = this.sourceIdentifiers.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        String string = this.getName();
        Collection collection = this.datasource.getDupSimpleName(string);
        if (collection != null && n != 1) {
            object = collection.iterator();
            while (object.hasNext()) {
                SourceIdentifiersList sourceIdentifiersList = (SourceIdentifiersList)object.next();
                if (sourceIdentifiersList == this) continue;
                sourceIdentifiersList.setFQNFlag(1);
            }
        }
        do {
            object = (SourceIdentifier)iterator.next();
            ((SourceIdentifier)object).setUseFQN(n);
        } while (iterator.hasNext());
        if (this.propSupport != null) {
            this.propSupport.firePropertyChange(PROP_FQN_FLAG, null, null);
        }
    }

    void setPackage(String string) {
        Iterator iterator = ((AbstractList)new ArrayList(this.sourceIdentifiers)).iterator();
        while (iterator.hasNext()) {
            SourceIdentifier sourceIdentifier = (SourceIdentifier)iterator.next();
            this.datasource.setPackage(string, sourceIdentifier);
        }
    }

    void commit() throws SourceException, IOException, BadLocationException {
        Iterator iterator = this.sourceIdentifiers.iterator();
        while (iterator.hasNext()) {
            SourceIdentifier sourceIdentifier = (SourceIdentifier)iterator.next();
            sourceIdentifier.commit();
        }
    }

    int count() {
        return this.sourceIdentifiers.size();
    }

    int fqnCount() {
        Iterator iterator = this.sourceIdentifiers.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            SourceIdentifier sourceIdentifier = (SourceIdentifier)iterator.next();
            if (!sourceIdentifier.reallyUseFQN()) continue;
            ++n;
        }
        return n;
    }

    String getName() {
        if (this.sourceIdentifiers.isEmpty()) {
            return "";
        }
        return ((SourceIdentifier)this.sourceIdentifiers.get(0)).getName();
    }

    String getFQN() {
        SourceIdentifier sourceIdentifier = this.getSourceIdentifier();
        if (sourceIdentifier == null) {
            return "";
        }
        return sourceIdentifier.getFQN();
    }

    String getPackage() {
        SourceIdentifier sourceIdentifier = this.getSourceIdentifier();
        if (sourceIdentifier == null) {
            return "";
        }
        return sourceIdentifier.getPackage();
    }

    String getSourceText() {
        SourceIdentifier sourceIdentifier = this.getSourceIdentifier();
        if (sourceIdentifier == null) {
            return "";
        }
        return sourceIdentifier.getSourceText();
    }

    boolean reallyUseFQN() {
        return this.fqnCount() == this.count();
    }

    private SourceIdentifier getSourceIdentifier() {
        if (this.sourceIdentifiers.isEmpty()) {
            return null;
        }
        return (SourceIdentifier)this.sourceIdentifiers.get(0);
    }

    void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propSupport == null) {
            SourceIdentifiersList sourceIdentifiersList = this;
            synchronized (sourceIdentifiersList) {
                if (this.propSupport == null) {
                    this.propSupport = new PropertyChangeSupport(this);
                }
            }
        }
        this.propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propSupport == null) {
            return;
        }
        this.propSupport.removePropertyChangeListener(propertyChangeListener);
    }
}

