/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TooManyListenersException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.java.ElementFactory;
import org.netbeans.modules.java.ErrConsumer;
import org.netbeans.modules.java.parser.DocumentModelBuilder;
import org.netbeans.modules.java.parser.DocumentModelUpdater;
import org.netbeans.modules.java.parser.JavaParser;
import org.netbeans.modules.java.parser.ParsableObjectRequest;
import org.netbeans.modules.java.parser.ParserAnnotation;
import org.netbeans.modules.java.settings.JavaSettings;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystemCapability;
import org.openide.text.CloneableEditorSupport;

public class ParseSourceRequest
implements ParsableObjectRequest,
ErrConsumer {
    public static final int STATE_WAITING = 0;
    public static final int STATE_READING = 1;
    public static final int STATE_CANCELLED = 2;
    public static final int STATE_ANALYSIS = 3;
    public static final int STATE_UPDATING = 4;
    public static final int STATE_COMPLETED = 10;
    private static final int READ_THRESHOLD = 2048;
    JavaParser.Env environment;
    ChangeListener listener;
    int state;
    boolean valid;
    int syntaxErrors;
    ElementFactory builder;
    CloneableEditorSupport editSupp;
    private int annotatedErrors = 0;
    private Map annotations = null;
    private String sourceName = null;
    private Collection sources;
    private Collection classes;
    private Collection bootclasses;

    public ParseSourceRequest() {
        JavaSettings javaSettings = JavaSettings.getDefault();
        this.state = 0;
        this.valid = true;
        this.classes = new ArrayList(javaSettings.getParserClassPathFS());
        this.bootclasses = new ArrayList(javaSettings.getParserBootPathFS());
        this.sources = new LinkedList();
        Enumeration enumeration = FileSystemCapability.COMPILE.fileSystems();
        while (enumeration.hasMoreElements()) {
            this.sources.add(enumeration.nextElement());
        }
        this.classes.addAll(this.sources);
    }

    public ParseSourceRequest(int n, String string) {
        this();
        this.annotatedErrors = n;
        this.sourceName = string;
    }

    ParseSourceRequest(JavaParser.Env env, CloneableEditorSupport cloneableEditorSupport) {
        this();
        this.editSupp = cloneableEditorSupport;
        this.environment = env;
    }

    public synchronized void addChangeListener(ChangeListener changeListener) throws TooManyListenersException {
        if (this.listener != null) {
            throw new TooManyListenersException();
        }
        this.listener = changeListener;
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        if (this.listener == changeListener) {
            this.listener = null;
        }
    }

    public void setEnvironment(JavaParser.Env env) {
        this.environment = env;
    }

    public void setEditorSupport(CloneableEditorSupport cloneableEditorSupport) {
        this.editSupp = cloneableEditorSupport;
    }

    public void sourceChanged() {
        if (this.state == 1) {
            this.valid = false;
        }
    }

    public void modelChanged() {
        if (this.state != 0 && this.state != 10) {
            this.valid = false;
        }
    }

    public void setSyntaxErrors(int n) {
        this.syntaxErrors = n;
    }

    public int getSyntaxErrors() {
        return this.syntaxErrors;
    }

    public void setSemanticErrors(int n) {
    }

    public ElementFactory getFactory() {
        if (this.builder == null) {
            this.builder = this.createBuilder(this.editSupp);
        }
        return this.builder;
    }

    public DocumentModelUpdater getUpdater() {
        DocumentModelUpdater documentModelUpdater = null;
        ElementFactory elementFactory = this.getFactory();
        if (elementFactory instanceof DocumentModelUpdater) {
            documentModelUpdater = (DocumentModelUpdater)((Object)elementFactory);
        }
        return documentModelUpdater;
    }

    protected ElementFactory createBuilder(CloneableEditorSupport cloneableEditorSupport) {
        return new DocumentModelBuilder(cloneableEditorSupport);
    }

    public void notifyReschedule() {
        this.builder = null;
        this.enterState(0);
    }

    protected void enterState(int n) {
        this.state = n;
        if (this.listener != null) {
            this.listener.stateChanged(new ChangeEvent(this));
        }
    }

    public char[] getSource() throws IOException {
        Object object;
        char[] cArray;
        int n;
        this.valid = true;
        this.enterState(1);
        Reader reader = this.environment.getSourceText();
        LinkedList<char[]> linkedList = new LinkedList<char[]>();
        int n2 = 0;
        do {
            int n3 = 0;
            cArray = new char[2048];
            while ((n = reader.read(cArray)) != -1 && (n3 += n) < cArray.length) {
            }
            if (n3 > 0) {
                linkedList.add(cArray);
            }
            n2 += n3;
        } while (n > 0);
        reader.close();
        cArray = new char[n2];
        n = 0;
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            object = (char[])iterator.next();
            int n4 = iterator.hasNext() ? ((Object)object).length : n2 - n;
            System.arraycopy(object, 0, cArray, n, n4);
            n += n4;
        }
        object = this.getFactory();
        if (object instanceof DocumentModelBuilder) {
            ((DocumentModelBuilder)object).setContent(cArray, this.editSupp.isDocumentLoaded());
        }
        return cArray;
    }

    public InputStream findCompiledClass(String string) {
        return this.environment.findCompiledClass(string);
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean needsProcessing() {
        return this.valid;
    }

    public void notifyStart() {
    }

    public void notifyComplete() {
        this.enterState(10);
        if (this.annotations == null) {
            this.annotations = new HashMap();
        }
    }

    public Object getParserType() {
        if (this.annotatedErrors != 0) {
            return "deep";
        }
        return "shallow";
    }

    public ErrConsumer getErrConsumer() {
        if (this.annotatedErrors != 0) {
            return this;
        }
        return null;
    }

    public void pushError(FileObject fileObject, int n, int n2, String string, String string2) {
        if (fileObject != null && !fileObject.getNameExt().equals(this.sourceName)) {
            return;
        }
        if (this.annotations == null) {
            this.annotations = new HashMap();
        }
        Integer n3 = new Integer(n);
        ParserAnnotation parserAnnotation = new ParserAnnotation(n, n2, string);
        ParserAnnotation parserAnnotation2 = (ParserAnnotation)this.annotations.get(n3);
        if (parserAnnotation2 != null) {
            parserAnnotation2.chain(parserAnnotation);
        } else if (this.annotations.size() < this.annotatedErrors) {
            this.annotations.put(n3, parserAnnotation);
        }
    }

    public Collection getAnnotations() {
        if (this.annotations != null) {
            return this.annotations.values();
        }
        return null;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public Collection getSourcePath() {
        return this.sources;
    }

    public Collection getLibraryPath() {
        return this.classes;
    }

    public Collection getBootClassPath() {
        return this.bootclasses;
    }
}

